/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwodarz.code.cloudflare.zone;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;

public class Analytics {
    private final JSONArray zones;

    public JSONObject getCountryMap() {
        JSONObject tmp;
        JSONArray result = new JSONArray();
        JSONArray zones = this.getZones();
        for (int i = 0; i < zones.length(); ++i) {
            JSONObject zone = zones.getJSONObject(i);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                tmp = new JSONObject();
                long time = df.parse(zone.getJSONObject("dimensions").getString("timeslot")).getTime() / 1000L;
                tmp.put("time", time);
                JSONArray map = new JSONArray();
                for (int k = 0; k < zone.getJSONObject("sum").getJSONArray("countryMap").length(); ++k) {
                    JSONObject country = zone.getJSONObject("sum").getJSONArray("countryMap").getJSONObject(k);
                    country.remove("__typename");
                    map.put((Object)country);
                }
                tmp.put("list", (Object)map);
                result.put((Object)tmp);
                continue;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        JSONObject res = new JSONObject();
        for (int i = 0; i < result.length(); ++i) {
            for (int j = 0; j < result.getJSONObject(i).getJSONArray("list").length(); ++j) {
                tmp = result.getJSONObject(i).getJSONArray("list").getJSONObject(j);
                int set = tmp.getInt("requests");
                if (res.has(tmp.getString("key"))) {
                    set += res.getInt(tmp.getString("key"));
                }
                res.put(tmp.getString("key"), set);
            }
        }
        res.put("detail", (Object)result);
        return res;
    }

    public JSONObject getContentTypeMap() {
        JSONArray result = new JSONArray();
        JSONArray zones = this.getZones();
        for (int i = 0; i < zones.length(); ++i) {
            JSONObject zone = zones.getJSONObject(i);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                JSONObject tmp = new JSONObject();
                long time = df.parse(zone.getJSONObject("dimensions").getString("timeslot")).getTime() / 1000L;
                tmp.put("time", time);
                JSONArray map = new JSONArray();
                for (int k = 0; k < zone.getJSONObject("sum").getJSONArray("contentTypeMap").length(); ++k) {
                    JSONObject country = zone.getJSONObject("sum").getJSONArray("contentTypeMap").getJSONObject(k);
                    country.remove("__typename");
                    map.put((Object)country);
                }
                tmp.put("list", (Object)map);
                result.put((Object)tmp);
                continue;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        JSONObject res = new JSONObject();
        res.put("detail", (Object)result);
        return res;
    }

    public JSONObject getRequests() {
        int i;
        JSONArray zones = this.getZones();
        JSONObject response = new JSONObject();
        JSONArray result = new JSONArray();
        for (i = 0; i < zones.length(); ++i) {
            JSONObject zone = zones.getJSONObject(i);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                JSONObject tmp = new JSONObject();
                long time = df.parse(zone.getJSONObject("dimensions").getString("timeslot")).getTime() / 1000L;
                tmp.put("time", time);
                tmp.put("requests", zone.getJSONObject("sum").getInt("requests"));
                tmp.put("cached", zone.getJSONObject("sum").getInt("cachedRequests"));
                result.put((Object)tmp);
                continue;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < result.length(); ++i) {
            int requests = result.getJSONObject(i).getInt("requests");
            int cached = result.getJSONObject(i).getInt("cached");
            if (response.has("requests")) {
                requests += response.getInt("requests");
            }
            if (response.has("cached")) {
                cached += response.getInt("cached");
            }
            response.put("requests", requests);
            response.put("cached", cached);
        }
        response.put("detail", (Object)result);
        return response;
    }

    private JSONArray getZones() {
        JSONArray zones = new JSONArray();
        for (int i = 0; i < this.zones.length(); ++i) {
            for (int j = 0; j < this.zones.getJSONObject(i).getJSONArray("zones").length(); ++j) {
                zones.put((Object)this.zones.getJSONObject(i).getJSONArray("zones").getJSONObject(j));
            }
        }
        return zones;
    }

    public Analytics(JSONArray zones) {
        this.zones = zones;
    }
}

