/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class StringUtils {
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    private StringUtils() {
    }

    public static boolean contains(String string, String s) {
        return string.indexOf(s) > -1;
    }

    public static String substVars(String val, String currentKey, Map cycleMap, Properties configProps) throws IllegalArgumentException {
        String substValue;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = -1;
        int startDelim = -1;
        do {
            int idx;
            if ((stopDelim = val.indexOf(DELIM_STOP, stopDelim + 1)) < 0) {
                return val;
            }
            startDelim = val.indexOf(DELIM_START);
            if (startDelim < 0) {
                return val;
            }
            while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
                if (idx >= stopDelim) continue;
                startDelim = idx;
            }
        } while (startDelim > stopDelim && stopDelim >= 0);
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.getProperty(variable, null) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = StringUtils.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }
}

