/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogActivator
implements LogListener,
BundleActivator,
ServiceListener {
    private ServiceReference logService;
    private BundleContext context;
    private Logger logger;
    static /* synthetic */ Class class$org$osgi$service$log$LogReaderService;

    protected LogActivator(Logger logger) {
        this.logger = logger;
    }

    BundleContext getBundleContext() {
        return this.context;
    }

    ServiceReference getLogServiceReference() {
        return this.logService;
    }

    void setBundleContext(BundleContext bc) {
        this.context = bc;
    }

    void setLogServiceReference(ServiceReference ref) {
        this.logService = ref;
    }

    public void logged(LogEntry le) {
        String message = le.getMessage();
        Logger thelogger = this.logger;
        if (le.getBundle() != null) {
            thelogger = LoggerFactory.getLogger(le.getBundle().getSymbolicName());
        }
        if (le.getServiceReference() != null) {
            message = le.getServiceReference().getProperty("service.pid") != null ? message + " [ServicePID=" + le.getServiceReference().getProperty("service.pid") + "]" : message + " [ServiceID=" + le.getServiceReference().getProperty("service.id") + "]";
        }
        switch (le.getLevel()) {
            case 4: {
                if (le.getException() != null) {
                    thelogger.debug(message, le.getException());
                    break;
                }
                thelogger.debug(message);
                break;
            }
            case 3: {
                if (le.getException() != null) {
                    thelogger.info(message, le.getException());
                    break;
                }
                thelogger.info(message);
                break;
            }
            case 2: {
                if (le.getException() != null) {
                    thelogger.warn(message, le.getException());
                    break;
                }
                thelogger.warn(message);
                break;
            }
            case 1: {
                if (le.getException() != null) {
                    thelogger.error(message, le.getException());
                    break;
                }
                thelogger.error(message);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext arg0) throws Exception {
        this.context = arg0;
        LogActivator logActivator = this;
        synchronized (logActivator) {
            this.context.addServiceListener((ServiceListener)this, "(objectClass=" + (class$org$osgi$service$log$LogReaderService == null ? (class$org$osgi$service$log$LogReaderService = LogActivator.class$("org.osgi.service.log.LogReaderService")) : class$org$osgi$service$log$LogReaderService).getName() + ")");
            this.logService = this.context.getServiceReference((class$org$osgi$service$log$LogReaderService == null ? (class$org$osgi$service$log$LogReaderService = LogActivator.class$("org.osgi.service.log.LogReaderService")) : class$org$osgi$service$log$LogReaderService).getName());
            if (this.logService != null) {
                LogReaderService reader = (LogReaderService)this.context.getService(this.logService);
                reader.addLogListener((LogListener)this);
            }
        }
    }

    public void stop(BundleContext bc) throws Exception {
        bc.removeServiceListener((ServiceListener)this);
        if (this.logService != null) {
            LogReaderService reader = (LogReaderService)bc.getService(this.logService);
            reader.removeLogListener((LogListener)this);
            this.logService = null;
        }
    }

    public synchronized void serviceChanged(ServiceEvent ev) {
        if (this.logService == null && ev.getType() == 1) {
            this.logService = ev.getServiceReference();
            LogReaderService reader = (LogReaderService)this.context.getService(this.logService);
            reader.addLogListener((LogListener)this);
            return;
        }
        if (this.logService != null && ev.getType() == 4 && this.logService == ev.getServiceReference()) {
            LogReaderService reader = (LogReaderService)this.context.getService(this.logService);
            reader.removeLogListener((LogListener)this);
            this.logService = null;
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

