/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.rose.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.ow2.chameleon.rose.disco.RemoteEntityDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tools {
    public static Collection<String> getRequiredIntents(ServiceReference sref) throws ClassCastException {
        HashSet<String> requiredintents = new HashSet<String>();
        Object exporObj = sref.getProperty("service.exported.intents");
        Object extraObj = sref.getProperty("service.exported.intents.extra");
        List<String> exportedIntents = null;
        List<String> extraIntents = null;
        if (exporObj != null) {
            exportedIntents = Collection.class.isInstance(exporObj) ? (List<String>)exporObj : Arrays.asList((String[])exporObj);
            requiredintents.addAll(exportedIntents);
        }
        if (extraObj != null) {
            extraIntents = Collection.class.isInstance(extraObj) ? (List<String>)extraObj : Arrays.asList((String[])extraObj);
            requiredintents.addAll(extraIntents);
        }
        return requiredintents;
    }

    public static Collection<String> getProvidedIntents(ServiceReference sref, Collection<String> exporterIntents) {
        HashSet<String> providedintents = new HashSet<String>();
        String[] serviceIntents = (String[])sref.getProperty("service.intents");
        if (serviceIntents != null) {
            providedintents.addAll(Arrays.asList(serviceIntents));
        }
        providedintents.addAll(exporterIntents);
        return providedintents;
    }

    public static Map<String, Object> getServiceProperties(ServiceReference sref, String[] blacklistPrefix) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : sref.getPropertyKeys()) {
            boolean ignore = false;
            for (String prefix : blacklistPrefix) {
                if (!key.startsWith(prefix)) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            properties.put(key, sref.getProperty(key));
        }
        return properties;
    }

    public static final List<String> getItfNames(ServiceReference sref) throws IllegalArgumentException {
        List<String> itfnames;
        Object itfs = sref.getProperty("service.exported.interfaces");
        if (itfs != null && !itfs.equals("*")) {
            try {
                itfnames = Arrays.asList((String[])itfs);
            }
            catch (ClassCastException ce) {
                throw new IllegalArgumentException("The property: service.exported.interfaces must be an Array of String or *.", ce);
            }
        } else {
            itfnames = Arrays.asList((String[])sref.getProperty("objectClass"));
        }
        return itfnames;
    }

    public static final String filterTrackServiceToBeExported(String[] configs) {
        StringBuilder orClauses = new StringBuilder();
        for (String config : configs) {
            orClauses.append("(service.exported.configs=" + config + ")");
        }
        return "(&(service.exported.interfaces=*)(|(&(service.exported.configs=nodefault)(|" + orClauses.toString() + ")" + ")" + "(&" + "(!(" + "service.exported.configs" + "=" + "nodefault" + "))" + "(" + "service.exported.configs" + "=*)" + ")" + "(!(" + "service.exported.configs" + "=*))" + ")" + ")";
    }

    public static final String filterTrackRemoteToBeImported(String[] configs, String[] mandatory) {
        StringBuilder andClauses = new StringBuilder();
        andClauses.append("(|");
        for (String config : configs) {
            andClauses.append("(remote.enity.configs=" + config + ")");
        }
        andClauses.append(")");
        for (String mandat : mandatory) {
            andClauses.append("(" + mandat + "=*)");
        }
        return "(&(objectClass=" + RemoteEntityDescription.class.getName() + ")" + andClauses + ")";
    }

    public static final String getEndpointName(ServiceReference sref, String[] configs) {
        Object name = sref.getProperty("endpoint.name");
        int i = 0;
        while (name == null && i < configs.length) {
            name = sref.getProperty(configs[i++] + "endpoint.name");
        }
        if (name == null) {
            name = sref.getProperty("instance.name");
        }
        if (name == null) {
            name = sref.getProperty("service.pid");
        }
        if (name == null) {
            name = "service" + String.valueOf(sref.getProperty("service.id"));
        }
        return String.valueOf(name);
    }

    public static boolean intentsResolved(Collection<String> providedintents, Collection<String> requiredintents) {
        return providedintents.containsAll(requiredintents);
    }
}

