/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.rose.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import org.osgi.framework.ServiceReference;
import org.ow2.chameleon.rose.RemoteIdGenerator;

public class DefaultRemoteIdGenerator
implements RemoteIdGenerator {
    private static String prefix;

    public DefaultRemoteIdGenerator() {
        try {
            prefix = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            prefix = UUID.randomUUID().toString();
        }
        prefix = prefix + "-" + System.getProperty("org.osgi.service.http.port");
    }

    public String generateRemoteId(ServiceReference sref, String exporterName) {
        String serviceid = String.valueOf(sref.getProperty("service.id"));
        return prefix + "-" + exporterName + "-" + serviceid;
    }
}

