/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.chameria.launcher;

import de.akquinet.chameria.launcher.SubstVars;
import de.akquinet.chameria.services.ActivationService;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.ow2.chameleon.core.Chameleon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChameRIA
extends Chameleon {
    public static final String CHAMERIA_INSTALL_LOCATION_PROP = "chameria.install.location";
    public static final String QT_PACKAGES = "com.trolltech.extensions.signalhandler, com.trolltech.qt, com.trolltech.qt.core, com.trolltech.qt.designer, com.trolltech.qt.gui, com.trolltech.qt.network, com.trolltech.qt.opengl, com.trolltech.qt.phonon, com.trolltech.qt.sql, com.trolltech.qt.svg, com.trolltech.qt.webkit, com.trolltech.qt.xml, com.trolltech.qt.xmlpatterns";
    public static final String SERVICE_PACKAGES = "de.akquinet.chameria.services";
    private Framework m_framework;
    private String[] m_args;
    private File cache;
    private List<Object> activations = new ArrayList<Object>();

    public ChameRIA(String core, boolean debug, String app, String runtime, String fileinstall, String config) throws Exception {
        super(core, debug, runtime, app, fileinstall, config, null);
    }

    public Map<String, String> getProperties(Map map) throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>(super.getProperties(map));
        String pcks = (String)conf.get("org.osgi.framework.system.packages.extra");
        conf.put("org.osgi.framework.system.packages.extra", "com.trolltech.extensions.signalhandler, com.trolltech.qt, com.trolltech.qt.core, com.trolltech.qt.designer, com.trolltech.qt.gui, com.trolltech.qt.network, com.trolltech.qt.opengl, com.trolltech.qt.phonon, com.trolltech.qt.sql, com.trolltech.qt.svg, com.trolltech.qt.webkit, com.trolltech.qt.xml, com.trolltech.qt.xmlpatterns,de.akquinet.chameria.services," + pcks);
        if (System.getProperty(CHAMERIA_INSTALL_LOCATION_PROP) != null) {
            File install = ChameRIA.detectLocation();
            if (install.exists()) {
                this.cache = new File(install, "chameleon-cache");
                conf.put("org.osgi.framework.storage", this.cache.getAbsolutePath());
            } else {
                String storage = (String)conf.get("org.osgi.framework.storage");
                this.cache = new File(storage);
            }
        } else {
            String storage = (String)conf.get("org.osgi.framework.storage");
            this.cache = new File(storage);
        }
        return conf;
    }

    public static File detectLocation() {
        String location = System.getProperty(CHAMERIA_INSTALL_LOCATION_PROP);
        location = SubstVars.substVars(location, CHAMERIA_INSTALL_LOCATION_PROP, null, System.getProperties());
        return new File(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Framework start(String[] args) throws BundleException {
        File lock = new File(this.cache, ".lock");
        if (lock.exists()) {
            return null;
        }
        this.m_framework = this.start();
        ChameRIA chameRIA = this;
        synchronized (chameRIA) {
            try {
                this.m_framework.getBundleContext().addServiceListener((ServiceListener)new ActivationListener(), "(objectClass=" + ActivationService.class.getName() + ")");
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
            this.activate(args, this.m_framework.getBundleContext());
        }
        return this.m_framework;
    }

    public void activate(String[] args, BundleContext context) {
        this.m_args = args;
        ServiceReference[] refs = null;
        try {
            refs = context.getServiceReferences(ActivationService.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        if (refs != null) {
            for (ServiceReference ref : refs) {
                ActivationService svc = (ActivationService)context.getService(ref);
                if (this.activations.contains(svc)) continue;
                svc.activation(args);
                this.activations.add(svc);
            }
        } else {
            System.out.println("No Activation service detected");
        }
    }

    public Framework start() throws BundleException {
        this.createLockFile();
        return super.start();
    }

    public void stop() throws BundleException, InterruptedException {
        if (this.m_framework != null && this.m_framework.getBundleContext() != null) {
            this.deactivate(this.m_framework.getBundleContext());
        }
        this.deleteLock();
        super.stop();
    }

    public Framework getFramework() {
        return this.m_framework;
    }

    public void deactivate(BundleContext context) {
        ServiceReference[] refs = null;
        try {
            refs = context.getServiceReferences(ActivationService.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        if (refs != null) {
            for (ServiceReference ref : refs) {
                ((ActivationService)context.getService(ref)).deactivation();
            }
        }
    }

    private void createLockFile() {
        File lock = new File(this.cache, ".lock");
        if (!this.cache.exists()) {
            this.cache.mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(lock);
            writer.write("1");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deleteLock() {
        File lock = new File(this.cache, ".lock");
        try {
            FileWriter writer = new FileWriter(lock);
            writer.write("0");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        lock.delete();
    }

    private class ActivationListener
    implements ServiceListener {
        private ActivationListener() {
        }

        public synchronized void serviceChanged(ServiceEvent ev) {
            if (ChameRIA.this.m_framework != null && ev.getType() == 1) {
                ActivationService svc = (ActivationService)ChameRIA.this.m_framework.getBundleContext().getService(ev.getServiceReference());
                if (!ChameRIA.this.activations.contains(svc)) {
                    svc.activation(ChameRIA.this.m_args);
                    ChameRIA.this.activations.add(svc);
                }
                return;
            }
            if (ChameRIA.this.m_framework != null && ev.getType() == 4) {
                ChameRIA.this.activations.remove(ChameRIA.this.m_framework.getBundleContext().getService(ev.getServiceReference()));
            }
        }
    }
}

