/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core;

import java.io.File;
import java.util.ArrayList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.ow2.chameleon.core.StringUtils;

public class DebugActivator
implements BundleActivator {
    public static final String SHELL = "org.apache.felix.shell";
    public static final String GOGO = "org.apache.felix.gogo";
    public static final String ARCH_SHELL = "org.apache.felix.ipojo.arch-";
    public static final String ARCH_GOGO = "org.apache.felix.ipojo.arch.gogo-";
    private File directory;

    public DebugActivator(File dir) {
        this.directory = dir;
    }

    public void start(BundleContext bc) throws Exception {
        Bundle bundle;
        int i;
        File[] files = this.directory.listFiles();
        ArrayList<Bundle> installed = new ArrayList<Bundle>();
        boolean gogo = this.isGogo(files);
        for (i = 0; i < files.length; ++i) {
            if (gogo) {
                if (!StringUtils.contains(files[i].getName(), GOGO) && !StringUtils.contains(files[i].getName(), ARCH_GOGO)) continue;
                bundle = bc.installBundle("reference:" + files[i].toURI().toURL().toExternalForm());
                installed.add(bundle);
                continue;
            }
            if (!StringUtils.contains(files[i].getName(), SHELL) && !StringUtils.contains(files[i].getName(), ARCH_SHELL)) continue;
            bundle = bc.installBundle("reference:" + files[i].toURI().toURL().toExternalForm());
            installed.add(bundle);
        }
        for (i = 0; i < installed.size(); ++i) {
            bundle = (Bundle)installed.get(i);
            bundle.start();
        }
    }

    private boolean isGogo(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            if (!StringUtils.contains(files[i].getName(), GOGO)) continue;
            return true;
        }
        return false;
    }

    public void stop(BundleContext bc) throws Exception {
    }
}

