/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleInstaller
implements BundleActivator,
ServiceListener {
    private static Logger logger = LoggerFactory.getLogger("org.ow2.chameleon");
    private File directory;
    private BundleContext context;
    private List configs;
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationAdmin;

    public BundleInstaller(File dir) {
        this.directory = dir;
    }

    public void start(BundleContext arg0) throws Exception {
        this.context = arg0;
        ArrayList jars = new ArrayList();
        ArrayList exploded = new ArrayList();
        this.configs = new ArrayList();
        this.traverse(jars, exploded, this.configs, this.directory);
        this.installBundles(arg0, jars, exploded);
        this.context.addServiceListener((ServiceListener)this, "(objectClass=" + (class$org$osgi$service$cm$ConfigurationAdmin == null ? (class$org$osgi$service$cm$ConfigurationAdmin = BundleInstaller.class$("org.osgi.service.cm.ConfigurationAdmin")) : class$org$osgi$service$cm$ConfigurationAdmin).getName() + ")");
        if (this.context.getServiceReference((class$org$osgi$service$cm$ConfigurationAdmin == null ? (class$org$osgi$service$cm$ConfigurationAdmin = BundleInstaller.class$("org.osgi.service.cm.ConfigurationAdmin")) : class$org$osgi$service$cm$ConfigurationAdmin).getName()) != null) {
            this.parseConfiguration(this.context, this.configs);
            logger.info("Configurations from " + this.directory.getAbsoluteFile() + " parsed");
        }
    }

    private void parseConfiguration(BundleContext context, List configs) throws Exception {
        ConfigurationAdmin admin = this.getConfigurationAdmin(context);
        for (int i = 0; i < configs.size(); ++i) {
            File f = (File)configs.get(i);
            Properties p = new Properties();
            FileInputStream in = new FileInputStream(f);
            p.load(in);
            ((InputStream)in).close();
            String[] pid = this.parsePid(f.getName());
            Hashtable<Object, Object> ht = new Hashtable<Object, Object>();
            ht.putAll(p);
            Configuration config = this.getConfiguration(pid[0], pid[1], admin);
            if (config.getBundleLocation() != null) {
                config.setBundleLocation(null);
            }
            logger.info("A configuration will be pushed " + ht);
            config.update(ht);
        }
    }

    private ConfigurationAdmin getConfigurationAdmin(BundleContext context) throws Exception {
        ServiceReference ref = context.getServiceReference((class$org$osgi$service$cm$ConfigurationAdmin == null ? (class$org$osgi$service$cm$ConfigurationAdmin = BundleInstaller.class$("org.osgi.service.cm.ConfigurationAdmin")) : class$org$osgi$service$cm$ConfigurationAdmin).getName());
        if (ref == null) {
            throw new Exception("Configuration Admin unavailable !");
        }
        return (ConfigurationAdmin)context.getService(ref);
    }

    private void installBundles(BundleContext context, List jars, List exploded) throws IOException, BundleException {
        int i;
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (i = 0; i < jars.size(); ++i) {
            File file = (File)jars.get(i);
            if (!file.getName().endsWith("jar")) continue;
            JarFile jar = new JarFile(file);
            if (jar.getManifest().getMainAttributes().getValue("Bundle-ManifestVersion") != null) {
                logger.info("Installing " + file.getName());
                Bundle bundle = context.installBundle("reference:" + file.toURI().toURL().toExternalForm());
                bundles.add(bundle);
                continue;
            }
            logger.warn("The file " + file.getName() + " is not a valid bundle -> ignored");
        }
        for (i = 0; i < exploded.size(); ++i) {
            File dir = (File)exploded.get(i);
            File manifestFile = new File(dir, "META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(new FileInputStream(manifestFile));
            if (manifest.getMainAttributes().getValue("Bundle-ManifestVersion") != null) {
                logger.info("Installing " + dir.getName());
                Bundle bundle = context.installBundle("reference:" + dir.toURI().toURL().toExternalForm());
                bundles.add(bundle);
                continue;
            }
            logger.warn("The file " + dir.getName() + " is not a valid bundle -> ignored");
        }
        for (i = 0; i < bundles.size(); ++i) {
            Bundle bundle = (Bundle)bundles.get(i);
            if (this.isFragment(bundle)) {
                logger.info("Fragment detected " + bundle.getSymbolicName());
                continue;
            }
            logger.info("Starting " + bundle.getSymbolicName());
            bundle.start();
        }
    }

    public void stop(BundleContext arg0) throws Exception {
        this.context.removeServiceListener((ServiceListener)this);
    }

    private void traverse(List jars, List exploded, List configs, File dir) {
        String[] list = dir.list();
        for (int i = 0; i < list.length; ++i) {
            File file = new File(dir, list[i]);
            if (file.isFile()) {
                if (list[i].endsWith(".jar")) {
                    jars.add(file);
                    continue;
                }
                if (!list[i].endsWith(".cfg")) continue;
                configs.add(file);
                continue;
            }
            File manifest = new File(file, "META-INF/MANIFEST.MF");
            if (!manifest.exists()) continue;
            exploded.add(file);
        }
    }

    String[] parsePid(String path) {
        String pid = path.substring(0, path.length() - ".cfg".length());
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    Configuration getConfiguration(String pid, String factoryPid, ConfigurationAdmin cm) throws Exception {
        Configuration newConfiguration = null;
        newConfiguration = factoryPid != null ? cm.createFactoryConfiguration(pid, null) : cm.getConfiguration(pid, null);
        return newConfiguration;
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            try {
                this.parseConfiguration(this.context, this.configs);
                logger.info("Configurations from " + this.directory.getAbsoluteFile() + " parsed");
            }
            catch (Exception e) {
                logger.error("Configurations from " + this.directory.getAbsoluteFile() + " can not be parsed correctly : " + e.getMessage(), e);
            }
        }
    }

    private boolean isFragment(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        Object header = headers.get("Fragment-Host");
        return header != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

