/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.json.impl;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.xml.XMLSerializer;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.chameleon.json.JSONBeanService;
import org.ow2.chameleon.json.JSONService;
import org.ow2.chameleon.json.JSONXMLService;

public class JSONServiceProvider
implements JSONService,
JSONXMLService,
JSONBeanService,
Pojo {
    private InstanceManager __IM;
    public static final String EMPTY_JSON = "{}";
    private static final int BUFFER_SIZE = 4096;
    private boolean __MfromXML$java_lang_String;
    private boolean __MfromXML$java_io_InputStream;
    private boolean __MarrayToList$net_sf_json_JSONArray;
    private boolean __MfromJSON$java_lang_String;
    private boolean __MfromJSON$java_io_InputStream;
    private boolean __MgetNull;
    private boolean __MtoJSON$java_util_Map;
    private boolean __MtoJSON$java_lang_Object;
    private boolean __MtoBean$java_lang_String$java_lang_Class;
    private boolean __MtoBean$java_lang_String$java_lang_Class$java_util_Map;
    private boolean __MtoBean$java_util_Map$java_lang_Class;

    public JSONServiceProvider() {
        this(null);
    }

    private JSONServiceProvider(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public String fromXML(String string) throws ParseException {
        String string2;
        if (!this.__MfromXML$java_lang_String) {
            return this.__fromXML(string);
        }
        try {
            this.__IM.onEntry((Object)this, "fromXML$java_lang_String", new Object[]{string});
            string2 = this.__fromXML(string);
            this.__IM.onExit((Object)this, "fromXML$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fromXML$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __fromXML(String xml) throws ParseException {
        if (xml == null || xml.length() == 0) {
            return EMPTY_JSON;
        }
        try {
            XMLSerializer serializer = new XMLSerializer();
            JSON json = serializer.read(xml);
            return json.toString();
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public String fromXML(InputStream inputStream) throws ParseException, IOException {
        String string;
        if (!this.__MfromXML$java_io_InputStream) {
            return this.__fromXML(inputStream);
        }
        try {
            this.__IM.onEntry((Object)this, "fromXML$java_io_InputStream", new Object[]{inputStream});
            string = this.__fromXML(inputStream);
            this.__IM.onExit((Object)this, "fromXML$java_io_InputStream", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fromXML$java_io_InputStream", throwable);
            throw throwable;
        }
        return string;
    }

    private String __fromXML(InputStream is) throws ParseException, IOException {
        String json = JSONServiceProvider.read(is);
        return this.fromXML(json);
    }

    private List arrayToList(JSONArray jSONArray) throws ParseException {
        List list;
        if (!this.__MarrayToList$net_sf_json_JSONArray) {
            return this.__arrayToList(jSONArray);
        }
        try {
            this.__IM.onEntry((Object)this, "arrayToList$net_sf_json_JSONArray", new Object[]{jSONArray});
            list = this.__arrayToList(jSONArray);
            this.__IM.onExit((Object)this, "arrayToList$net_sf_json_JSONArray", (Object)list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "arrayToList$net_sf_json_JSONArray", throwable);
            throw throwable;
        }
        return list;
    }

    private List __arrayToList(JSONArray array) throws ParseException {
        if (array == null || array.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            Object object = array.get(i);
            if (object instanceof JSONObject) {
                list.add(this.fromJSON(object.toString()));
                continue;
            }
            if (object instanceof JSONArray) {
                list.add(this.arrayToList((JSONArray)object));
                continue;
            }
            list.add(object);
        }
        return list;
    }

    public Map fromJSON(String string) throws ParseException {
        Map map;
        if (!this.__MfromJSON$java_lang_String) {
            return this.__fromJSON(string);
        }
        try {
            this.__IM.onEntry((Object)this, "fromJSON$java_lang_String", new Object[]{string});
            map = this.__fromJSON(string);
            this.__IM.onExit((Object)this, "fromJSON$java_lang_String", (Object)map);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fromJSON$java_lang_String", throwable);
            throw throwable;
        }
        return map;
    }

    private Map __fromJSON(String json) throws ParseException {
        if (json == null || json.length() == 0) {
            return new HashMap();
        }
        try {
            JsonConfig config = new JsonConfig();
            config.setHandleJettisonEmptyElement(false);
            config.setHandleJettisonSingleElementArray(false);
            JSONObject object = JSONObject.fromObject(json, config);
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator iterator = object.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object obj = object.get(key);
                if (obj instanceof JSONArray) {
                    map.put(key, this.arrayToList((JSONArray)obj));
                    continue;
                }
                if (obj instanceof JSONObject) {
                    Map inner = this.fromJSON(obj.toString());
                    map.put(key, inner);
                    continue;
                }
                map.put(key, obj);
            }
            return map;
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public Map fromJSON(InputStream inputStream) throws ParseException, IOException {
        Map map;
        if (!this.__MfromJSON$java_io_InputStream) {
            return this.__fromJSON(inputStream);
        }
        try {
            this.__IM.onEntry((Object)this, "fromJSON$java_io_InputStream", new Object[]{inputStream});
            map = this.__fromJSON(inputStream);
            this.__IM.onExit((Object)this, "fromJSON$java_io_InputStream", (Object)map);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fromJSON$java_io_InputStream", throwable);
            throw throwable;
        }
        return map;
    }

    private Map __fromJSON(InputStream is) throws ParseException, IOException {
        if (is == null) {
            return new HashMap();
        }
        String json = JSONServiceProvider.read(is);
        return this.fromJSON(json);
    }

    public Object getNull() {
        Object object;
        if (!this.__MgetNull) {
            return this.__getNull();
        }
        try {
            this.__IM.onEntry((Object)this, "getNull", new Object[0]);
            object = this.__getNull();
            this.__IM.onExit((Object)this, "getNull", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNull", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __getNull() {
        return JSONNull.getInstance();
    }

    private static String read(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    public String toJSON(Map map) {
        String string;
        if (!this.__MtoJSON$java_util_Map) {
            return this.__toJSON(map);
        }
        try {
            this.__IM.onEntry((Object)this, "toJSON$java_util_Map", new Object[]{map});
            string = this.__toJSON(map);
            this.__IM.onExit((Object)this, "toJSON$java_util_Map", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "toJSON$java_util_Map", throwable);
            throw throwable;
        }
        return string;
    }

    private String __toJSON(Map map) {
        if (map == null) {
            return EMPTY_JSON;
        }
        JSONObject json = JSONObject.fromObject(map);
        return json.toString();
    }

    public String toJSON(Object object) {
        String string;
        if (!this.__MtoJSON$java_lang_Object) {
            return this.__toJSON(object);
        }
        try {
            this.__IM.onEntry((Object)this, "toJSON$java_lang_Object", new Object[]{object});
            string = this.__toJSON(object);
            this.__IM.onExit((Object)this, "toJSON$java_lang_Object", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "toJSON$java_lang_Object", throwable);
            throw throwable;
        }
        return string;
    }

    private String __toJSON(Object bean) {
        if (bean == null) {
            return EMPTY_JSON;
        }
        JSONObject jsonObject = JSONObject.fromObject(bean);
        return jsonObject.toString();
    }

    public Object toBean(String string, Class clazz) throws ParseException {
        Object object;
        if (!this.__MtoBean$java_lang_String$java_lang_Class) {
            return this.__toBean(string, clazz);
        }
        try {
            this.__IM.onEntry((Object)this, "toBean$java_lang_String$java_lang_Class", new Object[]{string, clazz});
            object = this.__toBean(string, clazz);
            this.__IM.onExit((Object)this, "toBean$java_lang_String$java_lang_Class", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "toBean$java_lang_String$java_lang_Class", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __toBean(String json, Class clazz) throws ParseException {
        JSONObject jsonObject = JSONObject.fromObject(json);
        return JSONObject.toBean(jsonObject, clazz);
    }

    public Object toBean(String string, Class clazz, Map map) throws ParseException {
        Object object;
        if (!this.__MtoBean$java_lang_String$java_lang_Class$java_util_Map) {
            return this.__toBean(string, clazz, map);
        }
        try {
            this.__IM.onEntry((Object)this, "toBean$java_lang_String$java_lang_Class$java_util_Map", new Object[]{string, clazz, map});
            object = this.__toBean(string, clazz, map);
            this.__IM.onExit((Object)this, "toBean$java_lang_String$java_lang_Class$java_util_Map", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "toBean$java_lang_String$java_lang_Class$java_util_Map", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __toBean(String json, Class clazz, Map mapping) throws ParseException {
        JSONObject jsonObject = JSONObject.fromObject(json);
        return JSONObject.toBean(jsonObject, clazz, mapping);
    }

    public Object toBean(Map map, Class clazz) {
        Object object;
        if (!this.__MtoBean$java_util_Map$java_lang_Class) {
            return this.__toBean(map, clazz);
        }
        try {
            this.__IM.onEntry((Object)this, "toBean$java_util_Map$java_lang_Class", new Object[]{map, clazz});
            object = this.__toBean(map, clazz);
            this.__IM.onExit((Object)this, "toBean$java_util_Map$java_lang_Class", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "toBean$java_util_Map$java_lang_Class", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __toBean(Map json, Class clazz) {
        JSONObject jsonObject = JSONObject.fromObject(json);
        return JSONObject.toBean(jsonObject, clazz);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            // empty if block
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("fromXML$java_lang_String")) {
                this.__MfromXML$java_lang_String = true;
            }
            if (set.contains("fromXML$java_io_InputStream")) {
                this.__MfromXML$java_io_InputStream = true;
            }
            if (set.contains("arrayToList$net_sf_json_JSONArray")) {
                this.__MarrayToList$net_sf_json_JSONArray = true;
            }
            if (set.contains("fromJSON$java_lang_String")) {
                this.__MfromJSON$java_lang_String = true;
            }
            if (set.contains("fromJSON$java_io_InputStream")) {
                this.__MfromJSON$java_io_InputStream = true;
            }
            if (set.contains("getNull")) {
                this.__MgetNull = true;
            }
            if (set.contains("toJSON$java_util_Map")) {
                this.__MtoJSON$java_util_Map = true;
            }
            if (set.contains("toJSON$java_lang_Object")) {
                this.__MtoJSON$java_lang_Object = true;
            }
            if (set.contains("toBean$java_lang_String$java_lang_Class")) {
                this.__MtoBean$java_lang_String$java_lang_Class = true;
            }
            if (set.contains("toBean$java_lang_String$java_lang_Class$java_util_Map")) {
                this.__MtoBean$java_lang_String$java_lang_Class$java_util_Map = true;
            }
            if (set.contains("toBean$java_util_Map$java_lang_Class")) {
                this.__MtoBean$java_util_Map$java_lang_Class = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

