/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.BundleRevision;
import org.apache.felix.framework.cache.JarContent;
import org.apache.felix.framework.resolver.Content;
import org.apache.felix.framework.util.JarFileX;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;

class JarRevision
extends BundleRevision {
    private static final transient String BUNDLE_JAR_FILE = "bundle.jar";
    private File m_bundleFile = null;
    private final JarFileX m_jarFile;

    public JarRevision(Logger logger, Map configMap, File revisionRootDir, String location, boolean byReference) throws Exception {
        this(logger, configMap, revisionRootDir, location, byReference, null);
    }

    public JarRevision(Logger logger, Map configMap, File revisionRootDir, String location, boolean byReference, InputStream is) throws Exception {
        super(logger, configMap, revisionRootDir, location);
        this.m_bundleFile = byReference ? new File(location.substring(location.indexOf("file:") + "file:".length())) : new File(this.getRevisionRootDir(), BUNDLE_JAR_FILE);
        this.initialize(byReference, is);
        JarFileX jarFile = null;
        try {
            jarFile = BundleCache.getSecureAction().openJAR(this.m_bundleFile, false);
            if (jarFile == null) {
                throw new IOException("No JAR file found.");
            }
            this.m_jarFile = jarFile;
        }
        catch (Exception ex) {
            if (jarFile != null) {
                jarFile.close();
            }
            throw ex;
        }
    }

    public Map getManifestHeader() throws Exception {
        Manifest mf = this.m_jarFile.getManifest();
        Map headers = mf == null ? new HashMap() : mf.getMainAttributes();
        return new StringMap(headers, false);
    }

    public synchronized Content getContent() throws Exception {
        return new JarContent(this.getLogger(), this.getConfig(), this, this.getRevisionRootDir(), this.m_bundleFile, this.m_jarFile);
    }

    protected void close() throws Exception {
        this.m_jarFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(boolean byReference, InputStream is) throws Exception {
        try {
            if (!BundleCache.getSecureAction().fileExists(this.getRevisionRootDir())) {
                if (!BundleCache.getSecureAction().mkdir(this.getRevisionRootDir())) {
                    this.getLogger().log(1, this.getClass().getName() + ": Unable to create revision directory.");
                    throw new IOException("Unable to create archive directory.");
                }
                if (!byReference) {
                    if (is == null) {
                        URL url = BundleCache.getSecureAction().createURL(null, this.getLocation(), null);
                        URLConnection conn = url.openConnection();
                        String auth = BundleCache.getSecureAction().getSystemProperty("http.proxyAuth", null);
                        if (auth != null && auth.length() > 0 && ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol()))) {
                            String base64 = Util.base64Encode(auth);
                            conn.setRequestProperty("Proxy-Authorization", "Basic " + base64);
                        }
                        is = BundleCache.getSecureAction().getURLConnectionInputStream(conn);
                    }
                    BundleCache.copyStreamToFile(is, this.m_bundleFile);
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

