/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.ow2.chameleon.core.BundleInstaller;
import org.ow2.chameleon.core.CoreActivator;
import org.ow2.chameleon.core.DebugActivator;
import org.ow2.chameleon.core.LogActivator;
import org.ow2.chameleon.core.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chameleon {
    public static final String CORE_DIR = "core";
    public static final String RUNTIME_DIR = "runtime";
    public static final String APPLICATION_DIR = "application";
    public static final String DEPLOY_DIR = "deploy";
    public static final String CHAMELEON_PROPERTIES = "chameleon.properties";
    public static final String SYSTEM_PROPERTIES = "system.properties";
    public static final String CHAMELEON_LOG_LEVEL_PROPERTY = "chameleon.log.level";
    public static final String CHAMELEON_LOG_DIR_PROPERTY = "chameleon.log.dir";
    public static final String CHAMELEON_LOG_PROPERTY = "chameleon.log.enabled";
    public static final String CHAMELEON_LOGGER_NAME = "org.ow2.chameleon";
    public static final String CHAMELEON_LOG_DIR_DEFAULT = "log";
    public static final String CHAMELEON_LOG_LEVEL_DEFAULT = "info";
    public static final String CHAMELEON_RUNTIME_PROPERTY = "chameleon.runtime";
    public static final String CHAMELEON_CORE_PROPERTY = "chameleon.core";
    public static final String CHAMELEON_APP_PROPERTY = "chameleon.application";
    public static final String CHAMELEON_DEPLOY_PROPERTY = "chameleon.deploy";
    private static final int OSGI_STOP_TIMEOUT = 10000;
    private Framework framework;
    private boolean debug;
    private String core;
    private String runtime;
    private String application;
    private String deploy;
    private Logger logger;
    private List activators;
    static /* synthetic */ Class class$org$ow2$chameleon$core$Main;

    public Chameleon(boolean debug, String runtime, String app, String fi) throws Exception {
        this.debug = debug;
        this.core = CORE_DIR;
        if (runtime != null) {
            this.runtime = runtime;
        }
        if (app != null) {
            this.application = app;
        }
        if (fi != null) {
            this.deploy = fi;
        }
        HashMap map = new HashMap();
        this.populate(map, null);
        this.logger = Chameleon.initializeLoggingSystem(map, this.runtime, this.application, this.deploy, this.debug);
        this.activators = this.getActivators(map);
        Map config = this.getProperties(map);
        FrameworkFactory factory = Chameleon.getFrameworkFactory();
        this.framework = factory.newFramework(config);
    }

    public Chameleon(String core, boolean debug, String runtime, String app, String fi, String props, String sys) throws Exception {
        this.debug = debug;
        this.loadSystemProperties(sys);
        HashMap map = new HashMap();
        this.populate(map, props);
        if (core == null) {
            this.core = (String)map.get(CHAMELEON_CORE_PROPERTY);
            if (this.core == null) {
                this.core = CORE_DIR;
            }
        } else {
            this.core = core;
        }
        this.runtime = runtime == null ? (String)map.get(CHAMELEON_RUNTIME_PROPERTY) : runtime;
        this.application = app == null ? (String)map.get(CHAMELEON_APP_PROPERTY) : app;
        this.deploy = fi == null ? (String)map.get(CHAMELEON_DEPLOY_PROPERTY) : fi;
        this.logger = Chameleon.initializeLoggingSystem(map, this.runtime, this.application, this.deploy, this.debug);
        this.activators = this.getActivators(map);
        Map config = this.getProperties(map);
        FrameworkFactory factory = Chameleon.getFrameworkFactory();
        this.framework = factory.newFramework(config);
    }

    private void loadSystemProperties(String sys) throws Exception {
        Properties props = new Properties();
        File file = null;
        if (sys == null) {
            file = new File(SYSTEM_PROPERTIES);
        } else {
            file = new File(sys);
            if (!file.exists()) {
                throw new Exception("The given property file does not exist :" + file.getAbsolutePath());
            }
        }
        if (file.exists()) {
            try {
                props.load(new FileInputStream(file));
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String k = (String)e.nextElement();
                    String v = StringUtils.substVars((String)props.get(k), k, null, System.getProperties());
                    System.setProperty(k, v);
                }
            }
            catch (Exception e) {
                throw new Exception("Cannot read the system property file : " + file.getAbsolutePath(), e);
            }
        }
    }

    public static Logger initializeLoggingSystem(Map config, String runtime, String app, String fi, boolean debug) throws IOException {
        File f;
        if (System.getProperty(CHAMELEON_LOG_DIR_PROPERTY) == null) {
            if (config.get(CHAMELEON_LOG_DIR_PROPERTY) == null) {
                f = new File(CHAMELEON_LOG_DIR_DEFAULT);
                f.mkdirs();
                System.setProperty(CHAMELEON_LOG_DIR_PROPERTY, f.getAbsolutePath());
            } else {
                f = new File((String)config.get(CHAMELEON_LOG_DIR_PROPERTY));
                f.mkdirs();
                System.setProperty(CHAMELEON_LOG_DIR_PROPERTY, f.getAbsolutePath());
            }
        } else {
            f = new File(System.getProperty(CHAMELEON_LOG_DIR_PROPERTY));
            f.mkdirs();
        }
        if (System.getProperty(CHAMELEON_LOG_LEVEL_PROPERTY) == null) {
            if (config.get(CHAMELEON_LOG_LEVEL_PROPERTY) == null) {
                System.setProperty(CHAMELEON_LOG_LEVEL_PROPERTY, CHAMELEON_LOG_LEVEL_DEFAULT);
            } else {
                System.setProperty(CHAMELEON_LOG_LEVEL_PROPERTY, (String)config.get(CHAMELEON_LOG_LEVEL_PROPERTY));
            }
        }
        Logger log = LoggerFactory.getLogger(CHAMELEON_LOGGER_NAME);
        if (debug) {
            log.info("debug mode enabled");
        }
        if (runtime != null) {
            log.info("Chameleon runtime set to " + runtime);
        } else {
            log.info("Chameleon runtime set to runtime");
        }
        if (app != null) {
            log.info("Chameleon application set to " + app);
        } else {
            log.info("Chameleon application set to application");
        }
        if (fi != null) {
            log.info("Chameleon file install folder set to " + fi);
        } else {
            log.info("Chameleon file install folder set to deploy");
        }
        return log;
    }

    public Framework start() throws BundleException {
        this.framework.init();
        this.framework.start();
        if (this.activators != null) {
            for (int i = 0; i < this.activators.size(); ++i) {
                try {
                    ((BundleActivator)this.activators.get(i)).start(this.framework.getBundleContext());
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("Cannot start internal activator : " + this.activators.get(i), e);
                    throw new BundleException("Cannot start internal activator : " + this.activators.get(i) + " : " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.framework;
    }

    public void stop() throws BundleException, InterruptedException {
        if (this.framework.getState() == 32) {
            this.framework.stop();
            this.framework.waitForStop(10000L);
        }
    }

    private void populate(Map map, String properties) throws Exception {
        File props = null;
        if (properties == null) {
            props = new File(CHAMELEON_PROPERTIES);
            if (!props.exists()) {
                return;
            }
        } else {
            props = new File(properties);
            if (!props.exists()) {
                throw new Exception("The given property file does not exist :" + props.getAbsolutePath());
            }
        }
        Properties ps = new Properties();
        ps.load(new FileInputStream(props));
        Properties env = new Properties();
        env.putAll((Map<?, ?>)ps);
        env.putAll((Map<?, ?>)System.getProperties());
        Enumeration<Object> keys = ps.keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            String v = (String)ps.get(k);
            v = StringUtils.substVars(v, k, null, env);
            map.put(k, v);
        }
    }

    public Map getProperties(Map map) throws Exception {
        if (!map.containsKey("org.osgi.framework.storage.clean")) {
            map.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        if (!map.containsKey("ipojo.log.level")) {
            map.put("ipojo.log.level", "WARNING");
        }
        if (!map.containsKey("org.osgi.framework.storage")) {
            map.put("org.osgi.framework.storage", "chameleon-cache");
        }
        if (!map.containsKey("org.osgi.framework.system.packages.extra")) {
            map.put("org.osgi.framework.system.packages.extra", "org.osgi.service.cm; version=1.3.0,org.osgi.service.log; version=1.3.0, org.slf4j; version=1.6.1,org.slf4j.impl; version=1.6.1,org.slf4j.spi; version=1.6.1,org.slf4j.helpers; version=1.6.1");
        } else {
            String pcks = (String)map.get("org.osgi.framework.system.packages.extra");
            map.put("org.osgi.framework.system.packages.extra", "org.osgi.service.cm; version=1.3.0,org.osgi.service.log; version=1.3.0, org.slf4j; version=1.6.1,org.slf4j.impl; version=1.6.1,org.slf4j.spi; version=1.6.1,org.slf4j.helpers; version=1.6.1," + pcks);
        }
        map.put("felix.fileinstall.poll", "2000");
        if (this.deploy != null) {
            map.put("felix.fileinstall.dir", this.deploy);
        }
        if (this.debug) {
            map.put("felix.fileinstall.debug", "1");
        } else {
            map.put("felix.fileinstall.debug", "-1");
        }
        map.put("felix.fileinstall.bundles.new.start", "true");
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List getActivators(Map props) throws Exception {
        File file;
        ArrayList<Object> list = new ArrayList<Object>();
        boolean isLogDisabled = false;
        String e = (String)props.get(CHAMELEON_LOG_PROPERTY);
        if (e != null && e.equalsIgnoreCase("false")) {
            isLogDisabled = true;
        }
        if (!isLogDisabled) {
            list.add(new LogActivator(this.logger));
        }
        list.add(new CoreActivator(this.getCoreDirectory()));
        if (this.debug) {
            list.add(new DebugActivator(this.getCoreDirectory()));
        }
        if (this.runtime != null) {
            file = new File(this.runtime);
            if (!file.exists()) throw new Exception("The set runtime folder does not exist : " + this.runtime);
            list.add(new BundleInstaller(file));
        } else {
            file = new File(RUNTIME_DIR);
            if (file.exists()) {
                list.add(new BundleInstaller(file));
            } else {
                this.logger.warn("No runtime directory");
            }
        }
        if (this.application != null) {
            file = new File(this.application);
            if (!file.exists()) throw new Exception("The set application folder does not exist : " + this.application);
            list.add(new BundleInstaller(file));
            return list;
        } else {
            file = new File(APPLICATION_DIR);
            if (file.exists()) {
                list.add(new BundleInstaller(file));
                return list;
            } else {
                this.logger.warn("No application directory.");
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FrameworkFactory getFrameworkFactory() throws Exception {
        URL url = (class$org$ow2$chameleon$core$Main == null ? (class$org$ow2$chameleon$core$Main = Chameleon.class$("org.ow2.chameleon.core.Main")) : class$org$ow2$chameleon$core$Main).getClassLoader().getResource("META-INF/services/org.osgi.framework.launch.FrameworkFactory");
        if (url != null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String s = br.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0 && s.charAt(0) != '#') {
                        FrameworkFactory frameworkFactory = (FrameworkFactory)Class.forName(s).newInstance();
                        return frameworkFactory;
                    }
                    s = br.readLine();
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
        throw new Exception("Could not find framework factory.");
    }

    private File getCoreDirectory() throws Exception {
        File file = null;
        file = this.core != null ? new File(this.core) : new File(CORE_DIR);
        if (file.exists()) {
            return file;
        }
        throw new Exception("The Core directory does not exist");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

