/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.android.rindirect;

import de.akquinet.android.rindirect.RIndirect;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class RindirectMojo
extends AbstractMojo {
    private static final List<String> SUPPORTED_PACKAGING = new ArrayList<String>();
    private String m_target;
    private String m_package;
    private ArrayList<String> packages;
    private boolean m_verbose;
    private boolean m_skip;
    private String m_className;
    private String m_r;
    private MavenProject m_project;

    public void execute() throws MojoExecutionException {
        if (!SUPPORTED_PACKAGING.contains(this.m_project.getPackaging())) {
            this.info("The maven-rindirect-plugin does not support " + this.m_project.getPackaging() + ", nothing done");
            return;
        }
        if (this.m_skip) {
            this.info("Rindirect generation skipped");
            return;
        }
        if (this.m_package == null && (this.packages == null || this.packages.isEmpty())) {
            throw new MojoExecutionException("'packages' is missing in the plugin configuration");
        }
        if (this.packages == null) {
            this.packages = new ArrayList();
            if (this.m_package != null) {
                this.packages.add(this.m_package);
            }
        }
        this.info("Start Rindirect generation");
        File R = this.findRClass();
        this.info("R class found " + R.getAbsolutePath());
        File destination = new File(this.m_target, "generated-sources" + File.separator + "rindirect");
        destination.mkdirs();
        if (this.m_verbose) {
            RIndirect.LOGGER.setLevel(Level.ALL);
        } else {
            RIndirect.LOGGER.setLevel(Level.WARNING);
        }
        for (String pack : this.packages) {
            File packageFile = this.getPackageFile(destination, pack);
            File classFile = new File(packageFile, this.m_className + ".java");
            this.info("Generated file " + classFile.getAbsolutePath());
            RIndirect rindirect = new RIndirect(destination, pack, packageFile, this.m_className, classFile, R);
            try {
                rindirect.generate();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error during generation", e);
            }
        }
        this.info("Rindirect generation done");
        this.m_project.addCompileSourceRoot(destination.getAbsolutePath());
        this.info(destination.getAbsolutePath() + " added to source folders");
    }

    private File getPackageFile(File dest, String pack) throws MojoExecutionException {
        File packageFile = new File(dest, pack.replace(".", "/"));
        if (!packageFile.exists()) {
            if (!packageFile.mkdirs()) {
                throw new MojoExecutionException("Cannot create packages " + packageFile.getAbsolutePath());
            }
        } else if (!packageFile.isDirectory()) {
            throw new MojoExecutionException(packageFile.getAbsolutePath() + " is not a directory");
        }
        return packageFile;
    }

    private File findRClass() throws MojoExecutionException {
        if (this.m_r != null) {
            File r = new File(this.m_project.getBasedir(), this.m_r);
            if (!r.exists()) {
                throw new MojoExecutionException("Cannot find R file - File does not exist" + r.getAbsolutePath());
            }
            return r;
        }
        File r = null;
        File root = new File(this.m_target + File.separator + "generated-sources" + File.separator + "r");
        this.info("Search R class in " + root.getAbsolutePath());
        if (root.exists() && (r = RindirectMojo.findR(root)) == null) {
            root = new File(this.m_project.getBasedir(), "gen");
            this.info("Search R class in " + root.getAbsolutePath());
            if (root.exists()) {
                r = RindirectMojo.findR(root);
            }
        }
        if (r == null) {
            throw new MojoExecutionException("Cannot find the R class");
        }
        return r;
    }

    private static File findR(File root) {
        File[] files;
        for (File f : files = root.listFiles()) {
            if (f.isDirectory()) {
                return RindirectMojo.findR(f);
            }
            if (!"R.java".equals(f.getName())) continue;
            return f;
        }
        return null;
    }

    private void info(String message) {
        if (this.m_verbose) {
            this.getLog().info((CharSequence)message);
        }
    }

    static {
        SUPPORTED_PACKAGING.add("apk");
    }
}

