/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.tile;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;

public class Tile {
    @ApiModelProperty(value="x value of slippy tile", dataType="java.lang.Double", required=true, example="17340")
    private double x;
    @ApiModelProperty(value="y value of slippy tile", dataType="java.lang.Double", required=true, example="10785")
    private double y;
    @ApiModelProperty(value="zoom level of slippy tile", dataType="java.lang.Integer", required=true, example="15")
    private int zoom;

    public Tile(double x, double y, int zoom) {
        this.x = x;
        this.y = y;
        this.zoom = zoom;
    }

    public Tile() {
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tile)) {
            return false;
        }
        Tile tile = (Tile)o;
        if (Double.compare(tile.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(tile.y, this.y) != 0) {
            return false;
        }
        return this.zoom == tile.zoom;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.zoom;
        return result;
    }

    @JsonIgnore
    public Tile getRoundedTile() {
        return new Tile(Math.floor(this.x), Math.floor(this.y), this.zoom);
    }

    public String toString() {
        return "Tile{x=" + this.x + ", y=" + this.y + ", zoom=" + this.zoom + '}';
    }
}

