/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.parkingarea;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.aipark.api.chargingstation.ChargingPlugType;
import de.aipark.api.datasource.PublicDataSource;
import de.aipark.api.parkingarea.EntrancePoint;
import de.aipark.api.parkingarea.MapEntry;
import de.aipark.api.parkingarea.OpeningStatus;
import de.aipark.api.parkingarea.ParkingAreaType;
import de.aipark.api.parkingarea.ParkingOrientation;
import de.aipark.api.parkingarea.Schedule;
import de.aipark.api.payment.PriceModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ParkingArea {
    @ApiModelProperty(value="name of parking area", dataType="java.lang.String", required=true, example="Rathaus")
    private String name;
    @ApiModelProperty(value="shape of parking area, e.g. multipolygon for areas or line for on street parking", required=true)
    private Geometry shape;
    @ApiModelProperty(value="center point of parking area", required=true)
    private Point center;
    @ApiModelProperty(value="capacity of parking area (number of spots)", dataType="java.lang.Integer", required=true, example="100")
    private Integer capacity;
    @ApiModelProperty(value="type of parking area, types getting added in the future", dataType="de.aipark.api.parkingarea.ParkingAreaType", required=true, example="ON_STREET")
    private String parkingAreaType;
    @ApiModelProperty(value="orientation of parking", dataType="de.aipark.api.parkingarea.ParkingOrientation", example="PARALLEL")
    private ParkingOrientation parkingOrientation;
    @ApiModelProperty(value="unique id of parking area", dataType="java.lang.Long", required=true, example="504838")
    private Long id;
    @ApiModelProperty(value="value=null indicates no information about capacity designated for disabled, value>0 indicates number of spots designated for women, value=0 indicates no special capacity for women, value=-1 indicates that there are spots designated for women but capacity is unknown", dataType="java.lang.Integer", example="10")
    private Integer capacityWoman;
    @ApiModelProperty(value="value=null indicates no information about capacity designated for disabled, value>0 indicates number of spots designated for disabled, value=0 indicates no special capacity for disabled, value=-1 indicates that there are spots designated for disabled but capacity is unknown", dataType="java.lang.Integer", example="10")
    private Integer capacityDisabled;
    @ApiModelProperty(value="schedule when parking area is opened or closed", dataType="MapEntry<Schedule, OpeningStatus>")
    private MapEntry<Schedule, OpeningStatus> scheduleOpen;
    @ApiModelProperty(value="schedule for parking disc (value = allowed time in minutes)", dataType="MapEntry<Schedule, Integer>")
    private MapEntry<Schedule, Integer> scheduleMaxStay;
    @ApiModelProperty(value="price model mapping", dataType="MapEntry<Schedule, PriceModel>")
    private MapEntry<Schedule, PriceModel> schedulePriceModel;
    @ApiModelProperty(value="schedule with capacity of parking area (number of spots) for residential parking only", dataType="MapEntry<Schedule, Integer>")
    private MapEntry<Schedule, Integer> scheduleResidential;
    @ApiModelProperty(value="entrance point for parking area", dataType="List<EntrancePoint>")
    private List<EntrancePoint> entrancePoints;
    @JsonIgnore
    @Deprecated
    @ApiModelProperty(hidden=true, value="mapping of charging plug type to number of plugs with this type", dataType="MapEntry<ChargingPlugType,Integer>")
    private MapEntry<ChargingPlugType, Integer> chargingPlugTypes;
    @ApiModelProperty(value="must publish datasource list", dataType="List<PublicDataSource>")
    private List<PublicDataSource> mustPublishDatasourceList = new ArrayList<PublicDataSource>();

    public ParkingArea() {
        this.scheduleOpen = new MapEntry();
        this.scheduleMaxStay = new MapEntry();
        this.schedulePriceModel = new MapEntry();
        this.scheduleResidential = new MapEntry();
        this.entrancePoints = new ArrayList<EntrancePoint>();
        this.chargingPlugTypes = new MapEntry();
    }

    public ParkingArea(String name, Geometry shape, Point center, Integer capacity, String parkingAreaType, ParkingOrientation parkingOrientation, Long id, Integer capacityWoman, Integer capacityDisabled, MapEntry<Schedule, OpeningStatus> scheduleOpen, MapEntry<Schedule, Integer> scheduleMaxStay, MapEntry<Schedule, PriceModel> schedulePriceModel, MapEntry<Schedule, Integer> scheduleResidential, List<EntrancePoint> entrancePoints, MapEntry<ChargingPlugType, Integer> chargingPlugTypes) {
        this.name = name;
        this.shape = shape;
        this.center = center;
        this.capacity = capacity;
        this.parkingAreaType = parkingAreaType;
        this.parkingOrientation = parkingOrientation;
        this.id = id;
        this.capacityWoman = capacityWoman;
        this.capacityDisabled = capacityDisabled;
        this.scheduleOpen = scheduleOpen;
        this.scheduleMaxStay = scheduleMaxStay;
        this.schedulePriceModel = schedulePriceModel;
        this.scheduleResidential = scheduleResidential;
        this.entrancePoints = entrancePoints;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Geometry getShape() {
        return this.shape;
    }

    public void setShape(Geometry shape) {
        this.shape = shape;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public ParkingAreaType getParkingAreaType() {
        try {
            return ParkingAreaType.valueOf(this.parkingAreaType);
        }
        catch (IllegalArgumentException e) {
            return ParkingAreaType.PARKINGAREA;
        }
    }

    public void setParkingAreaType(String parkingAreaType) {
        this.parkingAreaType = parkingAreaType;
    }

    public ParkingOrientation getParkingOrientation() {
        return this.parkingOrientation;
    }

    public void setParkingOrientation(ParkingOrientation parkingOrientation) {
        this.parkingOrientation = parkingOrientation;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getCapacityWoman() {
        return this.capacityWoman;
    }

    public void setCapacityWoman(Integer capacityWoman) {
        this.capacityWoman = capacityWoman;
    }

    public Integer getCapacityDisabled() {
        return this.capacityDisabled;
    }

    public void setCapacityDisabled(Integer capacityDisabled) {
        this.capacityDisabled = capacityDisabled;
    }

    public MapEntry<Schedule, OpeningStatus> getScheduleOpen() {
        return this.scheduleOpen;
    }

    public void setScheduleOpen(MapEntry<Schedule, OpeningStatus> scheduleOpen) {
        this.scheduleOpen = scheduleOpen;
    }

    public MapEntry<Schedule, Integer> getScheduleMaxStay() {
        return this.scheduleMaxStay;
    }

    public void setScheduleMaxStay(MapEntry<Schedule, Integer> scheduleMaxStay) {
        this.scheduleMaxStay = scheduleMaxStay;
    }

    public MapEntry<Schedule, PriceModel> getSchedulePriceModel() {
        return this.schedulePriceModel;
    }

    public void setSchedulePriceModel(MapEntry<Schedule, PriceModel> schedulePriceModel) {
        this.schedulePriceModel = schedulePriceModel;
    }

    public MapEntry<Schedule, Integer> getScheduleResidential() {
        return this.scheduleResidential;
    }

    public void setScheduleResidential(MapEntry<Schedule, Integer> scheduleResidential) {
        this.scheduleResidential = scheduleResidential;
    }

    public List<EntrancePoint> getEntrancePoints() {
        return this.entrancePoints;
    }

    public void setEntrancePoints(List<EntrancePoint> entrancePoints) {
        this.entrancePoints = entrancePoints;
    }

    @Deprecated
    public MapEntry<ChargingPlugType, Integer> getChargingPlugTypes() {
        return this.chargingPlugTypes;
    }

    @Deprecated
    public void setChargingPlugTypes(MapEntry<ChargingPlugType, Integer> chargingPlugTypes) {
        this.chargingPlugTypes = chargingPlugTypes;
    }

    public Point getCenter() {
        return this.center;
    }

    public void setCenter(Point center) {
        this.center = center;
    }

    public List<PublicDataSource> getMustPublishDatasourceList() {
        return this.mustPublishDatasourceList;
    }

    public void setMustPublishDatasourceList(List<PublicDataSource> mustPublishDatasourceList) {
        this.mustPublishDatasourceList = mustPublishDatasourceList;
    }

    public String toString() {
        return "ParkingArea{name='" + this.name + '\'' + ", shape=" + this.shape + ", center=" + this.center + ", capacity=" + this.capacity + ", parkingAreaType='" + this.parkingAreaType + '\'' + ", parkingOrientation=" + (Object)((Object)this.parkingOrientation) + ", id=" + this.id + ", capacityWoman=" + this.capacityWoman + ", capacityDisabled=" + this.capacityDisabled + ", scheduleOpen=" + this.scheduleOpen + ", scheduleMaxStay=" + this.scheduleMaxStay + ", schedulePriceModel=" + this.schedulePriceModel + ", scheduleResidential=" + this.scheduleResidential + ", entrancePoints=" + this.entrancePoints + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParkingArea)) {
            return false;
        }
        ParkingArea that = (ParkingArea)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.shape != null ? !this.shape.equals(that.shape) : that.shape != null) {
            return false;
        }
        if (this.center != null ? !this.center.equals((Geometry)that.center) : that.center != null) {
            return false;
        }
        if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) {
            return false;
        }
        if (this.parkingAreaType != null ? !this.parkingAreaType.equals(that.parkingAreaType) : that.parkingAreaType != null) {
            return false;
        }
        if (this.parkingOrientation != that.parkingOrientation) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.capacityWoman != null ? !this.capacityWoman.equals(that.capacityWoman) : that.capacityWoman != null) {
            return false;
        }
        if (this.capacityDisabled != null ? !this.capacityDisabled.equals(that.capacityDisabled) : that.capacityDisabled != null) {
            return false;
        }
        if (this.scheduleOpen != null ? !this.scheduleOpen.equals(that.scheduleOpen) : that.scheduleOpen != null) {
            return false;
        }
        if (this.scheduleMaxStay != null ? !this.scheduleMaxStay.equals(that.scheduleMaxStay) : that.scheduleMaxStay != null) {
            return false;
        }
        if (this.schedulePriceModel != null ? !this.schedulePriceModel.equals(that.schedulePriceModel) : that.schedulePriceModel != null) {
            return false;
        }
        if (this.scheduleResidential != null ? !this.scheduleResidential.equals(that.scheduleResidential) : that.scheduleResidential != null) {
            return false;
        }
        if (this.entrancePoints != null ? !this.entrancePoints.equals(that.entrancePoints) : that.entrancePoints != null) {
            return false;
        }
        if (this.chargingPlugTypes != null ? !this.chargingPlugTypes.equals(that.chargingPlugTypes) : that.chargingPlugTypes != null) {
            return false;
        }
        return this.mustPublishDatasourceList != null ? this.mustPublishDatasourceList.equals(that.mustPublishDatasourceList) : that.mustPublishDatasourceList == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.shape != null ? this.shape.hashCode() : 0);
        result = 31 * result + (this.center != null ? this.center.hashCode() : 0);
        result = 31 * result + (this.capacity != null ? this.capacity.hashCode() : 0);
        result = 31 * result + (this.parkingAreaType != null ? this.parkingAreaType.hashCode() : 0);
        result = 31 * result + (this.parkingOrientation != null ? this.parkingOrientation.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.capacityWoman != null ? this.capacityWoman.hashCode() : 0);
        result = 31 * result + (this.capacityDisabled != null ? this.capacityDisabled.hashCode() : 0);
        result = 31 * result + (this.scheduleOpen != null ? this.scheduleOpen.hashCode() : 0);
        result = 31 * result + (this.scheduleMaxStay != null ? this.scheduleMaxStay.hashCode() : 0);
        result = 31 * result + (this.schedulePriceModel != null ? this.schedulePriceModel.hashCode() : 0);
        result = 31 * result + (this.scheduleResidential != null ? this.scheduleResidential.hashCode() : 0);
        result = 31 * result + (this.entrancePoints != null ? this.entrancePoints.hashCode() : 0);
        result = 31 * result + (this.chargingPlugTypes != null ? this.chargingPlugTypes.hashCode() : 0);
        result = 31 * result + (this.mustPublishDatasourceList != null ? this.mustPublishDatasourceList.hashCode() : 0);
        return result;
    }

    @JsonIgnore
    public String getPriceString() {
        ResourceBundle bundle = ResourceBundle.getBundle("Api");
        String result = "";
        HashMap<Schedule, ArrayList<PriceModel>> scheduleListMap = new HashMap<Schedule, ArrayList<PriceModel>>();
        for (MapEntry.Entry<Schedule, PriceModel> entry : this.schedulePriceModel.getEntryList()) {
            ArrayList<PriceModel> priceModels = (ArrayList<PriceModel>)scheduleListMap.get(entry.getKey());
            if (priceModels == null) {
                priceModels = new ArrayList<PriceModel>();
            }
            priceModels.add(entry.getValue());
            scheduleListMap.put(entry.getKey(), priceModels);
        }
        ArrayList schedules = new ArrayList(scheduleListMap.keySet());
        Collections.sort(schedules);
        boolean onlyDefaultPriceModels = false;
        for (Schedule schedule : schedules) {
            if (schedule.toString().isEmpty()) {
                if (schedules.size() > 1) {
                    result = result + bundle.getString("otherwise") + ":\n";
                } else {
                    onlyDefaultPriceModels = true;
                }
            } else {
                result = result + schedule.toString() + ":\n";
            }
            ArrayList priceModels = new ArrayList((Collection)scheduleListMap.get(schedule));
            Collections.sort(priceModels);
            boolean hasPeriodPricemodels = false;
            for (PriceModel priceModel : priceModels) {
                if (!onlyDefaultPriceModels) {
                    result = result + "\t";
                }
                if (priceModel.getFromMinute() != null || priceModel.getUntilMinute() != null) {
                    hasPeriodPricemodels = true;
                } else if (hasPeriodPricemodels && priceModel.getInterval() != null && priceModel.getMaxPriceInCent() == null) {
                    result = result + bundle.getString("otherwise") + " ";
                }
                result = result + priceModel.toString() + "\n";
            }
        }
        return result;
    }

    @JsonIgnore
    public String getMaxStayString() {
        ResourceBundle bundle = ResourceBundle.getBundle("Api");
        String result = "";
        for (MapEntry.Entry<Schedule, Integer> entry : this.scheduleMaxStay.getEntryList()) {
            if (!result.isEmpty()) {
                result = result + "\n";
            }
            result = result + entry.getKey().toString() + " " + bundle.getString("maximal") + " " + entry.getValue() + " " + bundle.getString("minutes");
        }
        return result;
    }

    @JsonIgnore
    public String getOpeningHoursString() {
        ResourceBundle bundle = ResourceBundle.getBundle("Api");
        String result = "";
        for (MapEntry.Entry<Schedule, OpeningStatus> entry : this.scheduleOpen.getEntryList()) {
            String opened = bundle.getString("closed");
            if (entry.getValue().equals((Object)OpeningStatus.OPEN)) {
                opened = bundle.getString("open");
            }
            result = result + entry.getKey().toString() + " " + opened + "\n";
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

