/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.optimalTrip;

import de.aipark.api.occupancy.ParkingAreaWithOccupancy;
import de.aipark.api.parkingarea.ParkingAreaType;
import de.aipark.api.route.Route;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class OptimalTrip {
    @ApiModelProperty(dataType="List")
    private List<Point> stopoverPoints;
    private List<ParkingAreaWithOccupancy> parkingAreaResultsOptimalTrip;
    private List<ParkingAreaWithOccupancy> parkingAreaResultsDriveBy;
    @ApiModelProperty(dataType="de.aipark.api.Route")
    private Route route;
    private Point destination;
    private boolean free;
    private boolean handicapped;
    private boolean resident;
    private double probability;
    private Integer parkingSpaces;
    private List<ParkingAreaType> preferredType;
    @ApiModelProperty(value="estimated search duration for a parking spot in seconds")
    private Integer estimatedSearchDuration;

    public OptimalTrip() {
        this.stopoverPoints = new ArrayList<Point>();
        this.parkingAreaResultsOptimalTrip = new ArrayList<ParkingAreaWithOccupancy>();
        this.free = false;
        this.handicapped = false;
        this.resident = false;
    }

    public OptimalTrip(List<Point> stopoverPoints, List<ParkingAreaWithOccupancy> parkingAreaResultsOptimalTrip, List<ParkingAreaWithOccupancy> parkingAreaResultsDriveBy, Route route, Point destination, boolean free, boolean handicapped, boolean resident, double probability, Integer parkingSpaces, List<ParkingAreaType> preferredType, Integer estimatedSearchDuration) {
        this.stopoverPoints = stopoverPoints;
        this.parkingAreaResultsOptimalTrip = parkingAreaResultsOptimalTrip;
        this.parkingAreaResultsDriveBy = parkingAreaResultsDriveBy;
        this.route = route;
        this.destination = destination;
        this.free = free;
        this.handicapped = handicapped;
        this.resident = resident;
        this.probability = probability;
        this.parkingSpaces = parkingSpaces;
        this.preferredType = preferredType;
        this.estimatedSearchDuration = estimatedSearchDuration;
    }

    public List<Point> getStopoverPoints() {
        return this.stopoverPoints;
    }

    public void setStopoverPoints(List<Point> stopoverPoints) {
        this.stopoverPoints = stopoverPoints;
    }

    public List<ParkingAreaWithOccupancy> getParkingAreaResultsOptimalTrip() {
        return this.parkingAreaResultsOptimalTrip;
    }

    public void setParkingAreaResultsOptimalTrip(List<ParkingAreaWithOccupancy> parkingAreaResultsOptimalTrip) {
        this.parkingAreaResultsOptimalTrip = parkingAreaResultsOptimalTrip;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public Point getDestination() {
        return this.destination;
    }

    public void setDestination(Point destination) {
        this.destination = destination;
    }

    public boolean isFree() {
        return this.free;
    }

    public void setFree(boolean free) {
        this.free = free;
    }

    public boolean isHandicapped() {
        return this.handicapped;
    }

    public void setHandicapped(boolean handicapped) {
        this.handicapped = handicapped;
    }

    public boolean isResident() {
        return this.resident;
    }

    public void setResident(boolean resident) {
        this.resident = resident;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }

    public Integer getParkingSpaces() {
        return this.parkingSpaces;
    }

    public void setParkingSpaces(Integer parkingSpaces) {
        this.parkingSpaces = parkingSpaces;
    }

    public List<ParkingAreaType> getPreferredType() {
        return this.preferredType;
    }

    public void setPreferredType(List<ParkingAreaType> preferredType) {
        this.preferredType = preferredType;
    }

    public Integer getEstimatedSearchDuration() {
        return this.estimatedSearchDuration;
    }

    public void setEstimatedSearchDuration(Integer estimatedSearchDuration) {
        this.estimatedSearchDuration = estimatedSearchDuration;
    }

    public List<ParkingAreaWithOccupancy> getParkingAreaResultsDriveBy() {
        return this.parkingAreaResultsDriveBy;
    }

    public void setParkingAreaResultsDriveBy(List<ParkingAreaWithOccupancy> parkingAreaResultsDriveBy) {
        this.parkingAreaResultsDriveBy = parkingAreaResultsDriveBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptimalTrip that = (OptimalTrip)o;
        if (this.free != that.free) {
            return false;
        }
        if (this.handicapped != that.handicapped) {
            return false;
        }
        if (this.resident != that.resident) {
            return false;
        }
        if (Double.compare(that.probability, this.probability) != 0) {
            return false;
        }
        if (this.stopoverPoints != null ? !this.stopoverPoints.equals(that.stopoverPoints) : that.stopoverPoints != null) {
            return false;
        }
        if (this.parkingAreaResultsOptimalTrip != null ? !this.parkingAreaResultsOptimalTrip.equals(that.parkingAreaResultsOptimalTrip) : that.parkingAreaResultsOptimalTrip != null) {
            return false;
        }
        if (this.parkingAreaResultsDriveBy != null ? !this.parkingAreaResultsDriveBy.equals(that.parkingAreaResultsDriveBy) : that.parkingAreaResultsDriveBy != null) {
            return false;
        }
        if (this.route != null ? !this.route.equals(that.route) : that.route != null) {
            return false;
        }
        if (this.destination != null ? !this.destination.equals((Geometry)that.destination) : that.destination != null) {
            return false;
        }
        if (this.parkingSpaces != null ? !this.parkingSpaces.equals(that.parkingSpaces) : that.parkingSpaces != null) {
            return false;
        }
        if (this.preferredType != null ? !this.preferredType.equals(that.preferredType) : that.preferredType != null) {
            return false;
        }
        return this.estimatedSearchDuration != null ? this.estimatedSearchDuration.equals(that.estimatedSearchDuration) : that.estimatedSearchDuration == null;
    }

    public int hashCode() {
        int result = this.stopoverPoints != null ? this.stopoverPoints.hashCode() : 0;
        result = 31 * result + (this.parkingAreaResultsOptimalTrip != null ? this.parkingAreaResultsOptimalTrip.hashCode() : 0);
        result = 31 * result + (this.parkingAreaResultsDriveBy != null ? this.parkingAreaResultsDriveBy.hashCode() : 0);
        result = 31 * result + (this.route != null ? this.route.hashCode() : 0);
        result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
        result = 31 * result + (this.free ? 1 : 0);
        result = 31 * result + (this.handicapped ? 1 : 0);
        result = 31 * result + (this.resident ? 1 : 0);
        long temp = Double.doubleToLongBits(this.probability);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.parkingSpaces != null ? this.parkingSpaces.hashCode() : 0);
        result = 31 * result + (this.preferredType != null ? this.preferredType.hashCode() : 0);
        result = 31 * result + (this.estimatedSearchDuration != null ? this.estimatedSearchDuration.hashCode() : 0);
        return result;
    }

    public String toString() {
        ResourceBundle bundle = ResourceBundle.getBundle("Api");
        String result = "";
        if (this.preferredType.size() > 0) {
            switch (this.preferredType.get(0)) {
                case CAR_PARK: {
                    result = result + bundle.getString("preferCarParks");
                    break;
                }
                case PARKINGAREA: 
                case ON_STREET: {
                    result = result + bundle.getString("preferFree");
                }
            }
        }
        return result;
    }
}

