/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.livedata.spot;

import de.aipark.api.livedata.spot.LiveSpotStatus;
import de.aipark.api.livedata.spot.ParkingSpotType;
import io.swagger.annotations.ApiModelProperty;
import java.sql.Timestamp;
import org.locationtech.jts.geom.Point;

public class LiveSpot {
    @ApiModelProperty(value="parking area id", dataType="java.lang.Long", required=true, example="3376765")
    private Long parkingAreaId;
    @ApiModelProperty(value="status of live spot, O for occupied, F for free, U for unknown", required=true, example="O")
    private LiveSpotStatus occupied;
    @ApiModelProperty(value="center point of parking spot", required=true)
    private Point position;
    @ApiModelProperty(value="timestamp of live spot (UNIX time (since 1970) in milliseconds)", dataType="java.lang.Long", required=true, example="1530224622127")
    private Timestamp timestamp;
    @ApiModelProperty(value="timestamp since when the LiveSpotStatus is set to current value (UNIX time (since 1970) in milliseconds)", dataType="java.lang.Long", required=true, example="1530224622127")
    private Timestamp sinceTimestamp;
    @ApiModelProperty(value="spot type, e.g. NORMAL,RESIDENTIAL,DISABLED,CHARGING,WOMAN,FIRE_RESCUE_PATH,NO_STANDING,NO_PARKING", required=true, example="NORMAL")
    private ParkingSpotType type;
    @ApiModelProperty(value="spot id", dataType="java.lang.Long", required=true, example="138")
    private Long spotId;

    public LiveSpot() {
    }

    public LiveSpot(Long parkingAreaId, LiveSpotStatus occupied, Point position, Timestamp timestamp, Timestamp sinceTimestamp, ParkingSpotType type, Long spotId) {
        this.parkingAreaId = parkingAreaId;
        this.occupied = occupied;
        this.position = position;
        this.timestamp = timestamp;
        this.sinceTimestamp = sinceTimestamp;
        this.type = type;
        this.spotId = spotId;
    }

    public Long getParkingAreaId() {
        return this.parkingAreaId;
    }

    public void setParkingAreaId(Long parkingAreaId) {
        this.parkingAreaId = parkingAreaId;
    }

    public LiveSpotStatus getOccupied() {
        return this.occupied;
    }

    public void setOccupied(LiveSpotStatus occupied) {
        this.occupied = occupied;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public ParkingSpotType getType() {
        return this.type;
    }

    public void setType(ParkingSpotType type) {
        this.type = type;
    }

    public Timestamp getSinceTimestamp() {
        return this.sinceTimestamp;
    }

    public void setSinceTimestamp(Timestamp sinceTimestamp) {
        this.sinceTimestamp = sinceTimestamp;
    }

    public Long getSpotId() {
        return this.spotId;
    }

    public void setSpotId(Long spotId) {
        this.spotId = spotId;
    }

    public String toString() {
        return "LiveSpot{parkingAreaId=" + this.parkingAreaId + ", occupied=" + (Object)((Object)this.occupied) + ", position=" + this.position + ", timestamp=" + this.timestamp + ", sinceTimestamp=" + this.sinceTimestamp + ", type=" + (Object)((Object)this.type) + ", spotId=" + this.spotId + '}';
    }
}

