package de.aipark.api.route;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateXY;

import java.util.List;

/**
 * class containing route information
 */
@ApiModel("RouteAPI")
public class Route {
    @ApiModelProperty(value = "distance in meter")
    private Integer distance;

    @ApiModelProperty(value = "duration in seconds")
    private Integer duration;

    @ApiModelProperty(value = "GPS-route coordinates, x=longitude, y=latitude", dataType = "List")
    private List<CoordinateXY> route;

    public Route() {
    }

    public Route(Integer distance, Integer duration, List<CoordinateXY> route) {
        this.distance = distance;
        this.duration = duration;
        //noinspection unchecked
        this.route = route;
    }

    public Integer getDistance() {
        return distance;
    }

    public void setDistance(Integer distance) {
        this.distance = distance;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public List<CoordinateXY> getRoute() {
        return route;
    }

    public void setRoute(List<CoordinateXY> route) {
        this.route = route;
    }
}
