package de.aipark.api.requestsResponse.getParkingAreasForTile;

import de.aipark.api.parkingarea.ParkingAreaDataFilter;
import de.aipark.api.tile.Tile;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by torgen on 29.08.17.
 */
public class GetParkingAreasForTileRequest {
    @ApiModelProperty(value = "tile of parking areas", dataType = "de.aipark.api.tile.Tile", required = true)
    private Tile tile;

    @ApiModelProperty(value = "list of filters, filter CAR_PARK combines filters for types: \"CAR_PARK, AIRPORT,PARKING_DECK_AUTOMATED, UNDERGROUND_PARKING, UNDERGROUND_PARKING_AUTOMATED \"",
            dataType = "[Ljava.lang.String;", example = "[\"FREE\"]", required = true,
            allowableValues = ParkingAreaDataFilter.ALLOWED_VALUES_LIST)
    private List<ParkingAreaDataFilter> filters = new ArrayList<ParkingAreaDataFilter>();

    public GetParkingAreasForTileRequest(Tile tile, List<ParkingAreaDataFilter> filters) {
        this.tile = tile;
        this.filters = filters;
    }

    public GetParkingAreasForTileRequest() {

    }

    public Tile getTile() {
        return tile;
    }

    public void setTile(Tile tile) {
        this.tile = tile;
    }

    public List<ParkingAreaDataFilter> getFilters() {
        return filters;
    }

    public void setFilters(List<ParkingAreaDataFilter> filters) {
        this.filters = filters;
    }

    @Override
    public String toString() {
        return "GetParkingAreasForTileRequest{" +
                "tile=" + tile +
                ", filters=" + filters +
                '}';
    }
}
