package de.aipark.api.requestsResponse.getOptimalTrip;

import de.aipark.api.optimalTrip.OptimalTrip;
import de.aipark.api.optimalTrip.Situation;
import de.aipark.api.parkingarea.MapEntry;
import io.swagger.annotations.ApiModelProperty;

import java.util.ResourceBundle;

/**
 * Created by torgen on 14.12.17.
 */
public class GetOptimalTripResponse {
    @ApiModelProperty(value = "optimal trips with priority, higher value means higher priority")
    private MapEntry<Integer,OptimalTrip> optimalTrips;

    private Situation situation;

    public GetOptimalTripResponse() {
        optimalTrips = new MapEntry<Integer,OptimalTrip>();
    }

    public GetOptimalTripResponse(MapEntry<Integer, OptimalTrip> optimalTrips, Situation situation) {
        this.optimalTrips = optimalTrips;
        this.situation = situation;
    }

    public MapEntry<Integer, OptimalTrip> getOptimalTrips() {
        return optimalTrips;
    }

    public void setOptimalTrips(MapEntry<Integer, OptimalTrip> optimalTrips) {
        this.optimalTrips = optimalTrips;
    }

    public Situation getSituation() {
        return situation;
    }

    public void setSituation(Situation situation) {
        this.situation = situation;
    }

    @Override
    public String toString() {
        ResourceBundle bundle = ResourceBundle.getBundle( "Api" );
        String result = "";
        switch (situation){
            case GOOD:
                result += bundle.getString("goodSituation");
                break;
            case MIDDLE:
                result += bundle.getString("middleSituation");
                break;
            case BAD:
                result += bundle.getString("badSituation");
                break;
            case UNKNOWN:
                result += bundle.getString("unknownSituation");
                break;
        }
        if(optimalTrips.getEntryList().size() < 1){
            result += ", " + bundle.getString("noAreasNearToDestination");
        }
        else if(!situation.equals(Situation.UNKNOWN)){
            result += ", " + optimalTrips.getEntryList().get(0).getValue().toString();
        }
        result += ".";
        return result;
    }
}
