package de.aipark.api.requestsResponse.getOptimalTrip;

import de.aipark.api.optimalTrip.Preference;
import de.aipark.api.parkingarea.ParkingAreaDataFilter;
import io.swagger.annotations.ApiModelProperty;
import org.locationtech.jts.geom.Point;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by torgen on 09.12.17.
 */
public class GetOptimalTripRequest {
    @ApiModelProperty(value = "departure position", required = true)
    private Point departure;

    @ApiModelProperty(value = "destination position of optimal trip", required = true)
    private Point destination;

    @ApiModelProperty(value = "departure time (UNIX time (since 1970) in milliseconds)", dataType = "java.lang.Long", required = true, example = "1476561575000")
    private Timestamp departureTimestamp;

    @ApiModelProperty(value = "list of filters, filter CAR_PARK combines filters for types: \"CAR_PARK, AIRPORT,PARKING_DECK_AUTOMATED, UNDERGROUND_PARKING, UNDERGROUND_PARKING_AUTOMATED \"",
            dataType = "[Ljava.lang.String;", example = "[\"FREE\"]", required = true,
            allowableValues = ParkingAreaDataFilter.ALLOWED_VALUES_LIST)
    private List<ParkingAreaDataFilter> filters = new ArrayList<ParkingAreaDataFilter>();

    @ApiModelProperty(value = "list of preferences", required = true)
    private List<Preference> preferences = new ArrayList<Preference>();

    @ApiModelProperty(value = "maximum duration in milli seconds for the whole trip", dataType = "java.lang.Long", required = true, example = "3600000")
    private Long duration;

    @ApiModelProperty(value = "maximum distance (in meter) for the whole trip", dataType = "java.lang.Integer", required = true, example = "2000")
    private Integer maxDistance;

    private GetDriveByParkingAreaResults getDriveByParkingAreaResults;

    public GetOptimalTripRequest() {
    }

    public GetOptimalTripRequest(Point departure, Point destination, Timestamp departureTimestamp, List<ParkingAreaDataFilter> filters, List<Preference> preferences, Long duration, Integer maxDistance, GetDriveByParkingAreaResults getDriveByParkingAreaResults) {
        this.departure = departure;
        this.destination = destination;
        this.departureTimestamp = departureTimestamp;
        this.filters = filters;
        this.preferences = preferences;
        this.duration = duration;
        this.maxDistance = maxDistance;
        this.getDriveByParkingAreaResults = getDriveByParkingAreaResults;
    }

    public Point getDeparture() {
        return departure;
    }

    public void setDeparture(Point departure) {
        this.departure = departure;
    }

    public Point getDestination() {
        return destination;
    }

    public void setDestination(Point destination) {
        this.destination = destination;
    }

    public Timestamp getDepartureTimestamp() {
        return departureTimestamp;
    }

    public void setDepartureTimestamp(Timestamp departureTimestamp) {
        this.departureTimestamp = departureTimestamp;
    }

    public List<ParkingAreaDataFilter> getFilters() {
        return filters;
    }

    public void setFilters(List<ParkingAreaDataFilter> filters) {
        this.filters = filters;
    }

    public List<Preference> getPreferences() {
        return preferences;
    }

    public void setPreferences(List<Preference> preferences) {
        this.preferences = preferences;
    }

    public Long getDuration() {
        return duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Integer getMaxDistance() {
        return maxDistance;
    }

    public void setMaxDistance(Integer maxDistance) {
        this.maxDistance = maxDistance;
    }

    public GetDriveByParkingAreaResults getGetDriveByParkingAreaResults() {
        return getDriveByParkingAreaResults;
    }

    public void setGetDriveByParkingAreaResults(GetDriveByParkingAreaResults getDriveByParkingAreaResults) {
        this.getDriveByParkingAreaResults = getDriveByParkingAreaResults;
    }

    @Override
    public String toString() {
        return "GetOptimalTripRequest{" +
                "departure=" + departure +
                ", destination=" + destination +
                ", departureTimestamp=" + departureTimestamp +
                ", filters=" + filters +
                ", preferences=" + preferences +
                ", duration=" + duration +
                ", maxDistance=" + maxDistance +
                ", getDriveByParkingAreaResults=" + getDriveByParkingAreaResults +
                '}';
    }
}
