package de.aipark.api.requestsResponse.getOptimalTrip;

import de.aipark.api.parkingarea.ParkingAreaType;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

public class GetDriveByParkingAreaResults {
    private final static double MAX_DISTANCE_DRIVE_BY_AREAS_DEFAULT_IN_M = 10;

    @ApiModelProperty(value = "max distance for drive by parking areas to route")
    private Double maxDistanceToRouteInM;

    @ApiModelProperty(value = "additional constraints for drive by parking areas")
    private List<GetDriveByParkingAreaResultsConstraint> getDriveByParkingAreaResultsConstraints;

    @ApiModelProperty(value = "only drive by parking areas with type contained in this list are returned, if list is empty or null, all parking areas are returned")
    private List<ParkingAreaType> driveByParkingAreaTypes;

    public GetDriveByParkingAreaResults() {
        maxDistanceToRouteInM = MAX_DISTANCE_DRIVE_BY_AREAS_DEFAULT_IN_M;
        getDriveByParkingAreaResultsConstraints = new ArrayList<GetDriveByParkingAreaResultsConstraint>();
        driveByParkingAreaTypes = new ArrayList<ParkingAreaType>();
    }

    public GetDriveByParkingAreaResults(Double maxDistanceToRouteInM, List<GetDriveByParkingAreaResultsConstraint> getDriveByParkingAreaResultsConstraints, List<ParkingAreaType> driveByParkingAreaTypes) {
        this.maxDistanceToRouteInM = maxDistanceToRouteInM;
        this.getDriveByParkingAreaResultsConstraints = getDriveByParkingAreaResultsConstraints;
        this.driveByParkingAreaTypes = driveByParkingAreaTypes;
    }

    public Double getMaxDistanceToRouteInM() {
        return maxDistanceToRouteInM;
    }

    public void setMaxDistanceToRouteInM(Double maxDistanceToRouteInM) {
        this.maxDistanceToRouteInM = maxDistanceToRouteInM;
    }

    public List<GetDriveByParkingAreaResultsConstraint> getGetDriveByParkingAreaResultsConstraints() {
        return getDriveByParkingAreaResultsConstraints;
    }

    public void setGetDriveByParkingAreaResultsConstraints(List<GetDriveByParkingAreaResultsConstraint> getDriveByParkingAreaResultsConstraints) {
        this.getDriveByParkingAreaResultsConstraints = getDriveByParkingAreaResultsConstraints;
    }

    public List<ParkingAreaType> getDriveByParkingAreaTypes() {
        return driveByParkingAreaTypes;
    }

    public void setDriveByParkingAreaTypes(List<ParkingAreaType> driveByParkingAreaTypes) {
        this.driveByParkingAreaTypes = driveByParkingAreaTypes;
    }
}
