package de.aipark.api.requestsResponse.getOccupancyForPosition;

import io.swagger.annotations.ApiModelProperty;
import org.locationtech.jts.geom.Point;

import java.sql.Timestamp;

/**
 * Created by torgen on 12.10.17.
 */
public class GetOccupancyForPositionRequest {
    @ApiModelProperty(value = "departurePosition for occupancy", required = true)
    private Point position;

    @ApiModelProperty(value = "timestamp for occupancy (UNIX time (since 1970) in milliseconds)", dataType = "java.lang.Long", required = true, example = "1476561575000")
    private Timestamp timestamp;

    public GetOccupancyForPositionRequest() {
    }

    public GetOccupancyForPositionRequest(Point position, Timestamp timestamp) {
        this.position = position;
        this.timestamp = timestamp;
    }

    public Point getPosition() {
        return position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public Timestamp getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String toString() {
        return "GetOccupancyForPositionRequest{" +
                "position=" + position +
                ", timestamp=" + timestamp +
                '}';
    }
}
