package de.aipark.api.requestsResponse.getOccupanciesForPositions;

import io.swagger.annotations.ApiModelProperty;
import org.locationtech.jts.geom.Point;

import java.sql.Timestamp;
import java.util.List;

/**
 * Created by torgen on 16.11.17.
 */
public class GetOccupanciesForPositionsRequest {
    @ApiModelProperty(value = "start timestamp (UNIX time (since 1970) in milliseconds)", dataType = "java.lang.Long", required = true, example = "1510822329017")
    private Timestamp startTimestamp;

    @ApiModelProperty(value = "end timestamp (UNIX time (since 1970) in milliseconds)", dataType = "java.lang.Long", required = true, example = "1510825929017")
    private Timestamp endTimestamp;

    @ApiModelProperty(value = "interval minutes", dataType = "java.lang.Integer", required = true, example = "15")
    private Integer intervalMinutes;

    @ApiModelProperty(value = "departurePositions for occupancy", dataType = "List")
    private List<Point> points;

    public GetOccupanciesForPositionsRequest() {
    }

    public GetOccupanciesForPositionsRequest(Timestamp startTimestamp, Timestamp endTimestamp, Integer intervalMinutes, List<Point> points) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.intervalMinutes = intervalMinutes;
        this.points = points;
    }

    public Timestamp getStartTimestamp() {
        return startTimestamp;
    }

    public void setStartTimestamp(Timestamp startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Timestamp getEndTimestamp() {
        return endTimestamp;
    }

    public void setEndTimestamp(Timestamp endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public Integer getIntervalMinutes() {
        return intervalMinutes;
    }

    public void setIntervalMinutes(Integer intervalMinutes) {
        this.intervalMinutes = intervalMinutes;
    }

    public List<Point> getPoints() {
        return points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    @Override
    public String toString() {
        return "GetOccupanciesForPositionsRequest{" +
                "startTimestamp=" + startTimestamp +
                ", endTimestamp=" + endTimestamp +
                ", intervalMinutes=" + intervalMinutes +
                ", points=" + points +
                '}';
    }
}
