package de.aipark.api.requestsResponse.getLiveParkEvents;

import de.aipark.api.tile.Tile;
import io.swagger.annotations.ApiModelProperty;

import java.sql.Timestamp;

/**
 * Created by torgen on 17.12.17.
 */
public class GetLiveOpenSpotsRequest {
    private Tile tile;

    @ApiModelProperty(value = "from timestamp (UNIX time (since 1970) in milliseconds)", dataType = "java.lang.Long", required = true, example = "1498568470000")
    private Timestamp fromTimestamp;

    @ApiModelProperty(value = "until timestamp (UNIX time (since 1970) in milliseconds)", dataType = "java.lang.Long", required = true, example = "1514811670000")
    private Timestamp untilTimestamp;

    public GetLiveOpenSpotsRequest() {
    }

    public GetLiveOpenSpotsRequest(Tile tile, Timestamp fromTimestamp, Timestamp untilTimestamp) {
        this.tile = tile;
        this.fromTimestamp = fromTimestamp;
        this.untilTimestamp = untilTimestamp;
    }

    public Tile getTile() {
        return tile;
    }

    public void setTile(Tile tile) {
        this.tile = tile;
    }

    public Timestamp getFromTimestamp() {
        return fromTimestamp;
    }

    public void setFromTimestamp(Timestamp fromTimestamp) {
        this.fromTimestamp = fromTimestamp;
    }

    public Timestamp getUntilTimestamp() {
        return untilTimestamp;
    }

    public void setUntilTimestamp(Timestamp untilTimestamp) {
        this.untilTimestamp = untilTimestamp;
    }

    @Override
    public String toString() {
        return "GetLiveParkEventsRequest{" +
                "tile=" + tile +
                ", fromTimestamp=" + fromTimestamp +
                ", untilTimestamp=" + untilTimestamp +
                '}';
    }
}
