package de.aipark.api.requestsResponse.getChargingStationsForPosition;

import de.aipark.api.chargingstation.ChargingStationFilter;
import io.swagger.annotations.ApiModelProperty;
import org.locationtech.jts.geom.Point;

/**
 * Created by torgen on 12.02.18.
 */
public class GetChargingStationsForPositionRequest {
    @ApiModelProperty(value = "coordinate for request", required = true)
    private Point position;

    @ApiModelProperty(value = "limit the results (optional)", example = "10")
    private Integer maxNumberOfChargingStations;

    @ApiModelProperty(value = "filter the results (optional)")
    private ChargingStationFilter chargingStationFilter = new ChargingStationFilter();

    public GetChargingStationsForPositionRequest() {
    }

    public GetChargingStationsForPositionRequest(Point position, Integer maxNumberOfChargingStations, ChargingStationFilter chargingStationFilter) {
        this.position = position;
        this.maxNumberOfChargingStations = maxNumberOfChargingStations;
        this.chargingStationFilter = chargingStationFilter;
    }

    public Point getPosition() {
        return position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public Integer getMaxNumberOfChargingStations() {
        return maxNumberOfChargingStations;
    }

    public void setMaxNumberOfChargingStations(Integer maxNumberOfChargingStations) {
        this.maxNumberOfChargingStations = maxNumberOfChargingStations;
    }

    public ChargingStationFilter getChargingStationFilter() {
        return chargingStationFilter;
    }

    public void setChargingStationFilter(ChargingStationFilter chargingStationFilter) {
        this.chargingStationFilter = chargingStationFilter;
    }

    @Override
    public String toString() {
        return "GetChargingStationsForPositionRequest{" +
                "position=" + position +
                ", maxNumberOfChargingStations=" + maxNumberOfChargingStations +
                ", chargingStationFilter=" + chargingStationFilter +
                '}';
    }
}
