package de.aipark.api.parkingarea;

import io.swagger.annotations.ApiModelProperty;
import org.locationtech.jts.geom.Point;

/**
 * Created by torgen on 11.08.17.
 */
public class EntrancePoint{
    @ApiModelProperty(value = "departurePosition of entrance point", required = true)
    private Point entrancePoint;

    @ApiModelProperty(value = "entrance height in centimeter", dataType = "java.lang.Integer", example = "200")
    private Integer entranceHeight;

    public EntrancePoint() {
    }

    public EntrancePoint(Point entrancePoint, Integer entranceHeight) {
        this.entrancePoint = entrancePoint;
        this.entranceHeight = entranceHeight;
    }

    public Point getEntrancePoint() {
        return entrancePoint;
    }

    public void setEntrancePoint(Point entrancePoint) {
        this.entrancePoint = entrancePoint;
    }

    public Integer getEntranceHeight() {
        return entranceHeight;
    }

    public void setEntranceHeight(Integer entranceHeight) {
        this.entranceHeight = entranceHeight;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        EntrancePoint that = (EntrancePoint) o;

        if (entrancePoint != null ? !entrancePoint.equals(that.entrancePoint) : that.entrancePoint != null)
            return false;
        return entranceHeight != null ? entranceHeight.equals(that.entranceHeight) : that.entranceHeight == null;
    }

    @Override
    public int hashCode() {
        int result = entrancePoint != null ? entrancePoint.hashCode() : 0;
        result = 31 * result + (entranceHeight != null ? entranceHeight.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "EntrancePoint{" +
                "entrancePoint=" + entrancePoint +
                ", entranceHeight=" + entranceHeight +
                '}';
    }
}
