package de.aipark.api.optimalTrip;

import de.aipark.api.occupancy.ParkingAreaWithOccupancy;
import de.aipark.api.parkingarea.ParkingAreaType;
import de.aipark.api.route.Route;
import io.swagger.annotations.ApiModelProperty;
import org.locationtech.jts.geom.Point;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

/**
 * Created by torgen on 09.12.17.
 */
public class OptimalTrip {
    @ApiModelProperty(dataType = "List")
    private List<Point> stopoverPoints;

    private List<ParkingAreaWithOccupancy> parkingAreaResultsOptimalTrip;

    private List<ParkingAreaWithOccupancy> parkingAreaResultsDriveBy;

    @ApiModelProperty(dataType = "de.aipark.api.Route")
    private Route route;

    private Point destination;
    private boolean free;
    private boolean handicapped;
    private boolean resident;
    private double probability;
    private Integer parkingSpaces;
    private List<ParkingAreaType> preferredType;

    @ApiModelProperty(value = "estimated search duration for a parking spot in seconds")
    private Integer estimatedSearchDuration;


    public OptimalTrip() {
        stopoverPoints = new ArrayList<Point>();
        parkingAreaResultsOptimalTrip = new ArrayList<ParkingAreaWithOccupancy>();
        free = false;
        handicapped = false;
        resident = false;
    }

    public OptimalTrip(List<Point> stopoverPoints, List<ParkingAreaWithOccupancy> parkingAreaResultsOptimalTrip, List<ParkingAreaWithOccupancy> parkingAreaResultsDriveBy, Route route, Point destination, boolean free, boolean handicapped, boolean resident, double probability, Integer parkingSpaces, List<ParkingAreaType> preferredType, Integer estimatedSearchDuration) {
        this.stopoverPoints = stopoverPoints;
        this.parkingAreaResultsOptimalTrip = parkingAreaResultsOptimalTrip;
        this.parkingAreaResultsDriveBy = parkingAreaResultsDriveBy;
        this.route = route;
        this.destination = destination;
        this.free = free;
        this.handicapped = handicapped;
        this.resident = resident;
        this.probability = probability;
        this.parkingSpaces = parkingSpaces;
        this.preferredType = preferredType;
        this.estimatedSearchDuration = estimatedSearchDuration;
    }

    public List<Point> getStopoverPoints() {
        return stopoverPoints;
    }

    public void setStopoverPoints(List<Point> stopoverPoints) {
        this.stopoverPoints = stopoverPoints;
    }

    public List<ParkingAreaWithOccupancy> getParkingAreaResultsOptimalTrip() {
        return parkingAreaResultsOptimalTrip;
    }

    public void setParkingAreaResultsOptimalTrip(List<ParkingAreaWithOccupancy> parkingAreaResultsOptimalTrip) {
        this.parkingAreaResultsOptimalTrip = parkingAreaResultsOptimalTrip;
    }

    public Route getRoute() {
        return route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public Point getDestination() {
        return destination;
    }

    public void setDestination(Point destination) {
        this.destination = destination;
    }

    public boolean isFree() {
        return free;
    }

    public void setFree(boolean free) {
        this.free = free;
    }

    public boolean isHandicapped() {
        return handicapped;
    }

    public void setHandicapped(boolean handicapped) {
        this.handicapped = handicapped;
    }

    public boolean isResident() {
        return resident;
    }

    public void setResident(boolean resident) {
        this.resident = resident;
    }

    public double getProbability() {
        return probability;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }

    public Integer getParkingSpaces() {
        return parkingSpaces;
    }

    public void setParkingSpaces(Integer parkingSpaces) {
        this.parkingSpaces = parkingSpaces;
    }

    public List<ParkingAreaType> getPreferredType() {
        return preferredType;
    }

    public void setPreferredType(List<ParkingAreaType> preferredType) {
        this.preferredType = preferredType;
    }

    public Integer getEstimatedSearchDuration() {
        return estimatedSearchDuration;
    }

    public void setEstimatedSearchDuration(Integer estimatedSearchDuration) {
        this.estimatedSearchDuration = estimatedSearchDuration;
    }

    public List<ParkingAreaWithOccupancy> getParkingAreaResultsDriveBy() {
        return parkingAreaResultsDriveBy;
    }

    public void setParkingAreaResultsDriveBy(List<ParkingAreaWithOccupancy> parkingAreaResultsDriveBy) {
        this.parkingAreaResultsDriveBy = parkingAreaResultsDriveBy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OptimalTrip that = (OptimalTrip) o;

        if (free != that.free) return false;
        if (handicapped != that.handicapped) return false;
        if (resident != that.resident) return false;
        if (Double.compare(that.probability, probability) != 0) return false;
        if (stopoverPoints != null ? !stopoverPoints.equals(that.stopoverPoints) : that.stopoverPoints != null)
            return false;
        if (parkingAreaResultsOptimalTrip != null ? !parkingAreaResultsOptimalTrip.equals(that.parkingAreaResultsOptimalTrip) : that.parkingAreaResultsOptimalTrip != null)
            return false;
        if (parkingAreaResultsDriveBy != null ? !parkingAreaResultsDriveBy.equals(that.parkingAreaResultsDriveBy) : that.parkingAreaResultsDriveBy != null)
            return false;
        if (route != null ? !route.equals(that.route) : that.route != null) return false;
        if (destination != null ? !destination.equals(that.destination) : that.destination != null) return false;
        if (parkingSpaces != null ? !parkingSpaces.equals(that.parkingSpaces) : that.parkingSpaces != null)
            return false;
        if (preferredType != null ? !preferredType.equals(that.preferredType) : that.preferredType != null)
            return false;
        return estimatedSearchDuration != null ? estimatedSearchDuration.equals(that.estimatedSearchDuration) : that.estimatedSearchDuration == null;
    }

    @Override
    public int hashCode() {
        int result;
        long temp;
        result = stopoverPoints != null ? stopoverPoints.hashCode() : 0;
        result = 31 * result + (parkingAreaResultsOptimalTrip != null ? parkingAreaResultsOptimalTrip.hashCode() : 0);
        result = 31 * result + (parkingAreaResultsDriveBy != null ? parkingAreaResultsDriveBy.hashCode() : 0);
        result = 31 * result + (route != null ? route.hashCode() : 0);
        result = 31 * result + (destination != null ? destination.hashCode() : 0);
        result = 31 * result + (free ? 1 : 0);
        result = 31 * result + (handicapped ? 1 : 0);
        result = 31 * result + (resident ? 1 : 0);
        temp = Double.doubleToLongBits(probability);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        result = 31 * result + (parkingSpaces != null ? parkingSpaces.hashCode() : 0);
        result = 31 * result + (preferredType != null ? preferredType.hashCode() : 0);
        result = 31 * result + (estimatedSearchDuration != null ? estimatedSearchDuration.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        ResourceBundle bundle = ResourceBundle.getBundle( "Api" );
        String result = "";
        if(preferredType.size() > 0){
            switch (preferredType.get(0)){
                case CAR_PARK:
                    result += bundle.getString("preferCarParks");
                    break;
                case PARKINGAREA:
                case ON_STREET:
                    result += bundle.getString("preferFree");
                    break;
            }
        }

        return result;
    }
}
