package de.aipark.api.occupancy;

import de.aipark.api.parkingarea.ParkingArea;
import io.swagger.annotations.ApiModelProperty;

/**
 * Created by torgen on 25.09.17.
 */
public class ParkingAreaWithOccupancy {
    @ApiModelProperty(value = "parking area", dataType = "de.aipark.api.parkingarea.ParkingArea", required = true)
    private ParkingArea parkingArea;

    @ApiModelProperty(value = "occupancy for parking area", dataType = "de.aipark.api.occupancy.Occupancy", required = true)
    private Occupancy occupancy;

    public ParkingAreaWithOccupancy() {
    }

    public ParkingAreaWithOccupancy(ParkingArea parkingArea, Occupancy occupancy) {
        this.parkingArea = parkingArea;
        this.occupancy = occupancy;
    }

    public ParkingArea getParkingArea() {
        return parkingArea;
    }

    public void setParkingArea(ParkingArea parkingArea) {
        this.parkingArea = parkingArea;
    }

    public Occupancy getOccupancy() {
        return occupancy;
    }

    public void setOccupancy(Occupancy occupancy) {
        this.occupancy = occupancy;
    }

    @Override
    public String toString() {
        return "ParkingAreaWithOccupancy{" +
                "parkingArea=" + parkingArea +
                ", occupancy=" + occupancy +
                '}';
    }
}
