package de.aipark.api.occupancy;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by torgen on 24.09.17.
 */
@SuppressWarnings("WeakerAccess")
@JsonIgnoreProperties(ignoreUnknown = true)
public class Occupancy implements Serializable {
    @ApiModelProperty(value = "id of parking area", dataType = "java.lang.Long", required = true, example = "504838")
    public long pId;

    /**
     * will be removed in future relase, use timestamp field instead
     */
    @Deprecated
    @ApiModelProperty(hidden = true, value = "will be removed in future release, use timestamp field instead", dataType = "java.lang.Long", example = "1476561575000")
    public Timestamp time; //TODO: remove because of C++ compatibility

    @ApiModelProperty(value = "occupancy time", dataType = "java.lang.Long", required = true, example = "1476561575000")
    public Timestamp timestamp;

    @ApiModelProperty(value = "percentage probability (value between 0 and 100) for at least one open parking spot if type is P (predicted) " +
            "or live number of open parking spots if type is L or LP (predicted number of open parking spots)",
            required = true, example = "80")
    public float value;

    @ApiModelProperty(value = "P for predicted (probability for at least one open parking spot), L for live data (live number of open parking spots), " +
            "LP for predicted live data (number of open parking spots), U for unknown, C for closed parking area", required = true, example = "P")
    public OccupancyType type;

    public Occupancy() {
    }

    public Occupancy(long pId, Timestamp timestamp, float value, OccupancyType type) {
        this.pId = pId;
        this.time = timestamp; //TODO: remove because of C++ compatibility
        this.timestamp = timestamp;
        this.value = value;
        this.type = type;
    }

    public long getpId() {
        return pId;
    }

    public void setpId(long pId) {
        this.pId = pId;
    }


    /**
     * will be removed in future relase, use timestamp field instead
     */
    @Deprecated
    //TODO: remove because of C++ compatibility
    public Timestamp getTime() {
        return time;
    }

    /**
     * will be removed in future relase, use timestamp field instead
     */
    @Deprecated
    //TODO: remove because of C++ compatibility
    public void setTime(Timestamp time) {
        this.time = time;
    }

    public Timestamp getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public float getValue() {
        return value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public OccupancyType getType() {
        return type;
    }

    public void setType(OccupancyType type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "Occupancy{" +
                "pId=" + pId +
                ", timestamp=" + timestamp +
                ", value=" + value +
                ", type=" + type +
                '}';
    }
}
