package de.aipark.api.device;

import de.aipark.api.datasource.Datasource;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * Created by Andreas on 02.11.16
 */
@SuppressWarnings({"unused", "WeakerAccess"})
public class OsVersion implements Serializable {

    private int id;

    @ApiModelProperty(required = true, allowableValues = "UNKNOWN,ANDROID_APP,GENERATED_DUMMY,IOS_APP", example = "GENERATED_DUMMY")
    private Datasource datasource;

    @ApiModelProperty(required = true, example = "13")
    private int sdk;

    @ApiModelProperty(required = true, example = "Android-6.0")
    private String version;

    public OsVersion() {
    }

    public OsVersion(Datasource datasource, int sdk, String version) {
        this.datasource = datasource;
        this.sdk = sdk;
        this.version = version;
    }

    public OsVersion(int id, Datasource datasource, int sdk, String version) {
        this.id = id;
        this.datasource = datasource;
        this.sdk = sdk;
        this.version = version;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Datasource getDatasource() {
        return datasource;
    }

    public void setDatasource(Datasource datasource) {
        this.datasource = datasource;
    }

    public int getSdk() {
        return sdk;
    }

    public void setSdk(int sdk) {
        this.sdk = sdk;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "OsVersion{" +
                "datasource=" + datasource +
                ", sdk=" + sdk +
                ", version=" + version + '\'' +
                '}';
    }
}
