package de.aipark.api.device;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * Created by Andreas on 02.11.16
 */
@SuppressWarnings({"unused", "WeakerAccess"})
public class DeviceModel implements Serializable {

    private int id;

    @ApiModelProperty(example = "M9")
    private String name;

    private DeviceManufacturer deviceManufacturer;

    public DeviceModel(){}

    public DeviceModel(String name, DeviceManufacturer deviceManufacturer) {
        this.name = name;
        this.deviceManufacturer = deviceManufacturer;
    }

    public DeviceModel(int id, String name, DeviceManufacturer deviceManufacturer) {
        this.id = id;
        this.name = name;
        this.deviceManufacturer = deviceManufacturer;
    }

    public int getId() {return id;}

    public void setId(int id) {this.id = id;}

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeviceManufacturer getDeviceManufacturer() {return deviceManufacturer;}

    public void setDeviceManufacturer(DeviceManufacturer deviceManufacturer) {this.deviceManufacturer = deviceManufacturer;}

    @Override
    public String toString() {
        return "DeviceModel{" +
                "id=" + id +
                ", name=" + name + '\'' +
                ", deviceManufacturer=" + deviceManufacturer +
                '}';
    }
}
