package de.aipark.api.device;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * Created by Andreas on 02.11.16
 */
@SuppressWarnings({"unused", "WeakerAccess"})
public class Device implements Serializable {

    private int id;

    @ApiModelProperty(value = "uuid of device for debugging purpose", required = false, example = "ca6bd4cf-b433-4537-b6f0-d94534d2fadf")
    private String uuid;

    @ApiModelProperty(required = true)
    private DeviceModel deviceModel;

    public Device() {
    }

    public Device(String uuid, DeviceModel deviceModel) {
        this.uuid = uuid;
        this.deviceModel = deviceModel;
    }

    public Device(int id, String uuid, DeviceModel deviceModel) {
        this.id = id;
        this.uuid = uuid;
        this.deviceModel = deviceModel;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public DeviceModel getDeviceModel() {
        return deviceModel;
    }

    public void setDeviceModel(DeviceModel deviceModel) {
        this.deviceModel = deviceModel;
    }

    @Override
    public String toString() {
        return "Device{" +
                "id=" + id +
                ", uuid=" + uuid + '\'' +
                ", deviceModel=" + deviceModel +
                '}';
    }
}
