package de.aipark.api.datasource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author fidanbicaj
 */
public class PublicDataSource implements Serializable {

    @JsonIgnore
    private int id;

    @ApiModelProperty(value = "name of the datasource", example = "CITY_BARCELONA")
    private String name;

    @ApiModelProperty(value = "label for displaying the datasource", example = "City of Barcelona")
    private String label;

    @ApiModelProperty(value = "license type", example = "Creative Commons")
    private String licenseType;

    public PublicDataSource() {
    }

    public PublicDataSource(String name, String label, String licenseType) {
        this.name = name;
        this.label = label;
        this.licenseType = licenseType;
    }


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLicenseType() {
        return licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return "PublicDataSource{" +
                "name='" + name + '\'' +
                ", label='" + label + '\'' +
                ", licenseType='" + licenseType + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PublicDataSource)) return false;

        PublicDataSource that = (PublicDataSource) o;

        return id == that.id;
    }

    @Override
    public int hashCode() {
        return id;
    }
}
