package de.aipark.api.datasource;

import io.swagger.annotations.ApiModelProperty;

public class DatasourceLicense {
    @ApiModelProperty(value = "license id in DB (optional)", example = "-1")
    private int id = -1;

    @ApiModelProperty(value = "license type description", required = true, example = "Creative Commons")
    private String licenseType;

    @ApiModelProperty(value = "if this datasource needs to be published (due to license conditions)", required = true)
    private boolean mustPublish = false;

    //empty constructor needed for serialization
    private DatasourceLicense() {

    }

    public DatasourceLicense(String licenseType, boolean mustPublish) {
        this.licenseType = licenseType;
        this.mustPublish = mustPublish;
    }

    public String getLicenseType() {
        return licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public boolean getMustPublish() {
        return mustPublish;
    }

    public void setMustPublish(boolean mustPublish) {
        this.mustPublish = mustPublish;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DatasourceLicense)) return false;

        DatasourceLicense license = (DatasourceLicense) o;

        if (id > 0 && license.id == id) return true;
        if (mustPublish != license.mustPublish) return false;
        return licenseType != null ? licenseType.equals(license.licenseType) : license.licenseType == null;
    }

    @Override
    public int hashCode() {
        int result = licenseType != null ? licenseType.hashCode() : 0;
        result = 31 * result + (mustPublish ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "License{" +
                "id=" + id +
                ", licenseType='" + licenseType + '\'' +
                ", mustPublish=" + mustPublish +
                '}';
    }
}
