/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.sdk.route;

import de.aipark.api.device.AppVersion;
import de.aipark.api.device.Device;
import de.aipark.api.device.OsVersion;
import de.aipark.api.sdk.route.RoutePoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;

@ApiModel(value="RouteSDK")
public class Route
implements Serializable {
    private long id;
    @ApiModelProperty(required=true)
    private AppVersion appVersion;
    @ApiModelProperty(required=true)
    private OsVersion osVersion;
    @ApiModelProperty(required=true)
    private Device device;
    @ApiModelProperty(required=true)
    private List<RoutePoint> routePoints;

    public Route() {
    }

    public Route(AppVersion appVersion, OsVersion osVersion, Device device, List<RoutePoint> routePoints) {
        this.appVersion = appVersion;
        this.osVersion = osVersion;
        this.device = device;
        this.routePoints = routePoints;
    }

    public Route(long id, AppVersion appVersion, OsVersion osVersion, Device device, List<RoutePoint> routePoints) {
        this.id = id;
        this.appVersion = appVersion;
        this.osVersion = osVersion;
        this.device = device;
        this.routePoints = routePoints;
    }

    public Route(long id, AppVersion appVersion, OsVersion osVersion, Device device) {
        this.id = id;
        this.appVersion = appVersion;
        this.osVersion = osVersion;
        this.device = device;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public AppVersion getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(AppVersion appVersion) {
        this.appVersion = appVersion;
    }

    public OsVersion getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(OsVersion osVersion) {
        this.osVersion = osVersion;
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public List<RoutePoint> getRoutePoints() {
        return this.routePoints;
    }

    public void setRoutePoints(List<RoutePoint> routePoints) {
        this.routePoints = routePoints;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (RoutePoint routePoint : this.routePoints) {
            stringBuilder.append(routePoint.toString()).append(", ");
        }
        stringBuilder.append("]");
        return "Route{id=" + this.id + ", appVersion=" + this.appVersion + ", osVersion=" + this.osVersion + ", device=" + this.device + ", routePoints=" + stringBuilder.toString() + '}';
    }
}

