/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.payment;

import io.swagger.annotations.ApiModelProperty;
import java.text.DecimalFormatSymbols;
import java.util.Currency;
import java.util.Locale;
import java.util.ResourceBundle;

public class PriceModel
implements Comparable<PriceModel> {
    public static final int PRICE_IN_CENT_PAID_BUT_UNKNOWN = -1;
    private static String DEFAULT_DECIMAL_SEPARATOR = ",";
    @ApiModelProperty(position=1, value="start time in minutes", example="30")
    private Integer fromMinute;
    @ApiModelProperty(position=2, value="end time in minutes", example="90")
    private Integer untilMinute;
    @ApiModelProperty(position=3, value="interval time in minutes, e.g. 50 cent per 30 minutes", dataType="java.lang.Integer", required=true, example="30")
    private Integer interval;
    @ApiModelProperty(position=4, value="price in cent or equivalent smallest currency unit, value=-1 means paid but price is unknown, value=0 means free", required=true, example="50")
    private Integer priceInCent;
    @ApiModelProperty(position=5, value="priority, e.g. one price model could dominate another", dataType="java.lang.Integer", example="50")
    private Integer priority;
    @ApiModelProperty(position=6, value="textual description for special price models", dataType="java.lang.String", example="Tennisclub")
    private String description;
    @ApiModelProperty(position=7, value="maximal price in cent or equivalent smallest currency unit", example="50")
    private Integer maxPriceInCent;
    @ApiModelProperty(position=8, value="3-digit currency code defined by ISO 4217 (the costs are in cent or equivalent smallest currency unit)", dataType="java.lang.String", example="EUR")
    private Currency currency;

    public PriceModel() {
    }

    public PriceModel(Integer fromMinute, Integer untilMinute, Integer interval, Integer priceInCent, Integer priority, String description, Integer maxPriceInCent, Currency currency) {
        this.fromMinute = fromMinute;
        this.untilMinute = untilMinute;
        this.interval = interval;
        this.priceInCent = priceInCent;
        this.priority = priority;
        this.description = description;
        this.maxPriceInCent = maxPriceInCent;
        this.currency = currency;
    }

    private void initDecimalSeparator() {
    }

    public Integer getFromMinute() {
        return this.fromMinute;
    }

    public void setFromMinute(Integer fromMinute) {
        this.fromMinute = fromMinute;
    }

    public Integer getUntilMinute() {
        return this.untilMinute;
    }

    public void setUntilMinute(Integer untilMinute) {
        this.untilMinute = untilMinute;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public Integer getPriceInCent() {
        return this.priceInCent;
    }

    public void setPriceInCent(Integer priceInCent) {
        this.priceInCent = priceInCent;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getMaxPriceInCent() {
        return this.maxPriceInCent;
    }

    public void setMaxPriceInCent(Integer maxPriceInCent) {
        this.maxPriceInCent = maxPriceInCent;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    @Override
    public int compareTo(PriceModel o) {
        if (!(this.getFromMinute() == null && this.getUntilMinute() == null || o.getFromMinute() != null && o.getUntilMinute() != null)) {
            return -1;
        }
        if (!(o.getFromMinute() == null && o.getUntilMinute() == null || this.getFromMinute() != null && this.getUntilMinute() != null)) {
            return 1;
        }
        if (this.getFromMinute() != null && o.getFromMinute() != null) {
            return this.getFromMinute() - o.getFromMinute();
        }
        if (this.getUntilMinute() != null && o.getUntilMinute() != null) {
            return this.getUntilMinute() - o.getUntilMinute();
        }
        if (this.getInterval() != null && o.getInterval() != null) {
            return this.getInterval() - o.getInterval();
        }
        if (this.getInterval() != null && o.getInterval() == null) {
            return -1;
        }
        if (this.getInterval() == null && o.getInterval() != null) {
            return 1;
        }
        if (this.getMaxPriceInCent() == null && o.getMaxPriceInCent() != null) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PriceModel)) {
            return false;
        }
        PriceModel that = (PriceModel)o;
        if (this.fromMinute != null ? !this.fromMinute.equals(that.fromMinute) : that.fromMinute != null) {
            return false;
        }
        if (this.untilMinute != null ? !this.untilMinute.equals(that.untilMinute) : that.untilMinute != null) {
            return false;
        }
        if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) {
            return false;
        }
        if (this.priceInCent != null ? !this.priceInCent.equals(that.priceInCent) : that.priceInCent != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.maxPriceInCent != null ? !this.maxPriceInCent.equals(that.maxPriceInCent) : that.maxPriceInCent != null) {
            return false;
        }
        return this.currency != null ? this.currency.equals(that.currency) : that.currency == null;
    }

    public int hashCode() {
        int result = this.fromMinute != null ? this.fromMinute.hashCode() : 0;
        result = 31 * result + (this.untilMinute != null ? this.untilMinute.hashCode() : 0);
        result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
        result = 31 * result + (this.priceInCent != null ? this.priceInCent.hashCode() : 0);
        result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.maxPriceInCent != null ? this.maxPriceInCent.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        return result;
    }

    public String toString() {
        ResourceBundle bundle = ResourceBundle.getBundle("Api");
        String result = "";
        if (!(this.description != null && !this.description.isEmpty() || this.priceInCent != null && this.priceInCent != -1 || this.maxPriceInCent != null)) {
            result = result + bundle.getString("withCosts") + " ";
        } else if (this.priceInCent != null && this.priceInCent != -1) {
            result = result + this.getCurrencyAsString(this.priceInCent) + " ";
        }
        if (this.maxPriceInCent != null) {
            result = result + bundle.getString("maximal") + " " + this.getCurrencyAsString(this.maxPriceInCent) + " ";
        }
        if (this.interval != null) {
            result = result + bundle.getString("inIntervalOf") + " " + this.getTimeString(this.interval, bundle, true) + " ";
        }
        if (this.fromMinute != null && this.fromMinute > 0) {
            result = this.untilMinute != null ? result + " " : result + " " + bundle.getString("from") + " ";
            result = result + this.getTimeString(this.fromMinute, bundle, false) + " ";
        }
        if (this.untilMinute != null) {
            result = result + bundle.getString("until") + " " + this.getTimeString(this.untilMinute, bundle, false) + " ";
        }
        if (this.description != null) {
            result = result + this.description;
        }
        result = result.trim();
        return result;
    }

    private String getTimeString(Integer minute, ResourceBundle bundle, boolean isInterval) {
        int days = (int)Math.floor((float)minute.intValue() / 60.0f / 24.0f);
        int hours = minute / 60 % 24;
        int minutes = minute % 60;
        String time = "";
        if (days > 0) {
            time = days == 1 ? (isInterval ? bundle.getString("day") + " " : bundle.getString("oneDay") + " ") : days + " " + bundle.getString("days") + " ";
        }
        if (hours > 0) {
            String hourString = "";
            if (!time.isEmpty()) {
                hourString = hourString + bundle.getString("and") + " ";
            }
            hourString = hours == 1 ? (isInterval ? hourString + bundle.getString("hour") + " " : hourString + bundle.getString("oneHour") + " ") : hourString + hours + " " + bundle.getString("hours") + " ";
            time = time + hourString;
        }
        if (minutes > 0) {
            String minuteString = "";
            if (!time.isEmpty()) {
                minuteString = minuteString + bundle.getString("and") + " ";
            }
            minuteString = minutes == 1 ? (isInterval ? minuteString + bundle.getString("minute") + " " : minuteString + bundle.getString("oneMinute") + " ") : minuteString + minutes + " " + bundle.getString("minutes") + " ";
            time = time + minuteString;
        }
        time = time.trim();
        return time;
    }

    @Deprecated
    protected String getCurrencyAsString(Integer priceInCent) {
        String currencySymbol = this.currency == null ? "?" : this.currency.getSymbol(Locale.getDefault());
        return this.getCurrencyAsString(priceInCent, DEFAULT_DECIMAL_SEPARATOR, currencySymbol, false);
    }

    protected String getCurrencyAsString(Integer priceInCent, String decimalSeparator, String currencySymbol, boolean displayBeforePrice) {
        int currencyFullPart = priceInCent / 100;
        int currencyCentPart = priceInCent % 100;
        String centString = "" + currencyCentPart;
        if (currencyCentPart < 10) {
            centString = "0" + centString;
        }
        String priceString = currencyFullPart + decimalSeparator + centString;
        return displayBeforePrice ? currencySymbol + priceString : priceString + currencySymbol;
    }

    static {
        try {
            DEFAULT_DECIMAL_SEPARATOR = String.valueOf(DecimalFormatSymbols.getInstance().getDecimalSeparator());
        }
        catch (Throwable t) {
            System.out.println("Error initializing DECIMAL SEPARATOR, using default (\"" + DEFAULT_DECIMAL_SEPARATOR + "\")");
        }
    }
}

