/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.datasource;

import io.swagger.annotations.ApiModelProperty;

public class DatasourceLicense {
    @ApiModelProperty(value="license id in DB (optional)", example="-1")
    private int id = -1;
    @ApiModelProperty(value="license type description", required=true, example="Creative Commons")
    private String licenseType;
    @ApiModelProperty(value="if this datasource needs to be published (due to license conditions)", required=true)
    private boolean mustPublish = false;

    private DatasourceLicense() {
    }

    public DatasourceLicense(String licenseType, boolean mustPublish) {
        this.licenseType = licenseType;
        this.mustPublish = mustPublish;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public boolean getMustPublish() {
        return this.mustPublish;
    }

    public void setMustPublish(boolean mustPublish) {
        this.mustPublish = mustPublish;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatasourceLicense)) {
            return false;
        }
        DatasourceLicense license = (DatasourceLicense)o;
        if (this.id > 0 && license.id == this.id) {
            return true;
        }
        if (this.mustPublish != license.mustPublish) {
            return false;
        }
        return this.licenseType != null ? this.licenseType.equals(license.licenseType) : license.licenseType == null;
    }

    public int hashCode() {
        int result = this.licenseType != null ? this.licenseType.hashCode() : 0;
        result = 31 * result + (this.mustPublish ? 1 : 0);
        return result;
    }

    public String toString() {
        return "License{id=" + this.id + ", licenseType='" + this.licenseType + '\'' + ", mustPublish=" + this.mustPublish + '}';
    }
}

