package de.aipark.api.webservice;

import de.aipark.api.datasource.Datasource;
import de.aipark.api.livedata.spot.LiveSpot;
import de.aipark.api.parkevent.ParkEventLiveLeaving;
import de.aipark.api.requestsResponse.getChargingStationsForPosition.GetChargingStationsForPositionRequest;
import de.aipark.api.requestsResponse.getChargingStationsForPosition.GetChargingStationsForPositionResponse;
import de.aipark.api.requestsResponse.getChargingStationsForTile.GetChargingStationsForTileRequest;
import de.aipark.api.requestsResponse.getChargingStationsForTile.GetChargingStationsForTileResponse;
import de.aipark.api.requestsResponse.getCostsForParkingAreas.GetCostsForParkingAreasRequest;
import de.aipark.api.requestsResponse.getCostsForParkingAreas.GetCostsForParkingAreasResponse;
import de.aipark.api.requestsResponse.getDatasourcesToPublishForMergedId.ParkingAreaRequest;
import de.aipark.api.requestsResponse.getLiveParkEvents.GetLiveParkEventsRequest;
import de.aipark.api.requestsResponse.getLiveSpots.GetLiveSpotsForTileRequest;
import de.aipark.api.requestsResponse.getOccupancyForParkingAreas.GetOccupancyForParkingAreasRequest;
import de.aipark.api.requestsResponse.getOccupancyForParkingAreas.GetOccupancyForParkingAreasResponse;
import de.aipark.api.requestsResponse.getOptimalTrip.GetOptimalTripRequest;
import de.aipark.api.requestsResponse.getOptimalTrip.GetOptimalTripResponse;
import de.aipark.api.requestsResponse.getParkingAreasForPosition.GetParkingAreasForPositionRequest;
import de.aipark.api.requestsResponse.getParkingAreasForPosition.GetParkingAreasForPositionResponse;
import de.aipark.api.requestsResponse.getParkingAreasForPositionWithOccupancy.GetParkingAreasForPositionWithOccupancyRequest;
import de.aipark.api.requestsResponse.getParkingAreasForPositionWithOccupancy.GetParkingAreasForPositionWithOccupancyResponse;
import de.aipark.api.requestsResponse.getParkingAreasForPositionWithOccupancyForDeparture.GetParkingAreasForPositionWithOccupancyForDepartureRequest;
import de.aipark.api.requestsResponse.getParkingAreasForTile.GetParkingAreasForTileRequest;
import de.aipark.api.requestsResponse.getParkingAreasForTile.GetParkingAreasForTileResponse;
import de.aipark.api.requestsResponse.getParkingAreasForTileWithOccupancy.GetParkingAreasForTileWithOccupancyRequest;
import de.aipark.api.requestsResponse.getParkingAreasForTileWithOccupancy.GetParkingAreasForTileWithOccupancyResponse;
import de.aipark.api.requestsResponse.getParkingAreasForTileWithOccupancyForDeparture.GetParkingAreasForTileWithOccupancyForDepartureRequest;
import retrofit2.http.Body;
import retrofit2.http.POST;
import rx.Observable;

import java.util.List;

/**
 * Created by mathias on 28.02.16.
 */
public interface AiparkApiEndpointInterface {
    @POST(Webservice.GET_PARKING_AREAS_FOR_TILE)
    Observable<GetParkingAreasForTileResponse> getParkingAreasForTile(@Body GetParkingAreasForTileRequest tileParkingAreasRequest);
    @POST(Webservice.GET_OCCUPANCY_FOR_PARKING_AREAS)
    Observable<GetOccupancyForParkingAreasResponse> getOccupancyForParkingAreas(@Body GetOccupancyForParkingAreasRequest getOccupancyForParkingAreasRequest);
    @POST(Webservice.GET_PARKING_AREAS_FOR_TILE_WITH_OCCUPANCY)
    Observable<GetParkingAreasForTileWithOccupancyResponse> getParkingAreasForTileWithOccupancy(@Body GetParkingAreasForTileWithOccupancyRequest getParkingAreasForTileWithOccupancyRequest);
    @POST(Webservice.GET_PARKING_AREAS_FOR_TILE_WITH_OCCUPANCY_FOR_DEPARTURE)
    Observable<GetParkingAreasForTileWithOccupancyResponse> getParkingAreasForTileWithOccupancyForPosition(@Body GetParkingAreasForTileWithOccupancyForDepartureRequest getParkingAreasForTileWithOccupancyForPositionRequest);
    @POST(Webservice.GET_PARKING_AREAS_FOR_POSITION)
    Observable<GetParkingAreasForPositionResponse> getParkingAreasForPosition(@Body GetParkingAreasForPositionRequest getParkingAreasForPositionRequest);
    @POST(Webservice.GET_PARKING_AREAS_FOR_POSITION_WITH_OCCUPANCY)
    Observable<GetParkingAreasForPositionWithOccupancyResponse> getParkingAreasForPositionWithOccupancy(@Body GetParkingAreasForPositionWithOccupancyRequest getParkingAreasForPositionRequest);
    @POST(Webservice.GET_PARKING_AREAS_FOR_POSITION_WITH_OCCUPANCY_FOR_DEPARTURE)
    Observable<GetParkingAreasForPositionWithOccupancyResponse> getParkingAreasForPositionWithOccupancyForPosition(@Body GetParkingAreasForPositionWithOccupancyForDepartureRequest getParkingAreasForPositionRequest);
    @POST(Webservice.GET_OPTIMAL_TRIP)
    Observable<GetOptimalTripResponse> getOptimalTrip(@Body GetOptimalTripRequest getOptimalTripRequest);
    @POST(Webservice.GET_LIVE_PARK_EVENTS)
    Observable<List<ParkEventLiveLeaving>> getLiveParkEvents(@Body GetLiveParkEventsRequest getLiveParkEventsRequest);

    @POST(Webservice.GET_COSTS_FOR_PARKING_AREAS)
    Observable<GetCostsForParkingAreasResponse> getCostsForParkingAreas(@Body GetCostsForParkingAreasRequest getCostsForParkingAreasRequest);
    @POST(Webservice.GET_CHARGING_STATIONS_FOR_TILE)
    Observable<GetChargingStationsForTileResponse> getChargingStationsForTile(@Body GetChargingStationsForTileRequest getChargingStationsForTileRequest);
    @POST(Webservice.GET_CHARGING_STATIONS_FOR_POSITION)
    Observable<GetChargingStationsForPositionResponse> getChargingStationsForPosition(@Body GetChargingStationsForPositionRequest getChargingStationsForPositionRequest);
    @POST(Webservice.GET_LIVE_SPOTS_FOR_TILE)
    Observable<List<LiveSpot>> getLiveSpotsForTile(@Body GetLiveSpotsForTileRequest getLiveSpotsForTileRequest);
    @POST(Webservice.GET_DATASOURCES_TO_PUBLISH_FOR_MERGED_ID)
    Observable<List<Datasource>> getDatasourcesToPublishForParkingArea(@Body ParkingAreaRequest parkingAreaRequest);
}
