package de.aipark.api.webservice;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.aipark.api.datasource.Datasource;
import de.aipark.api.livedata.spot.LiveSpot;
import de.aipark.api.parkevent.ParkEventLiveLeaving;
import de.aipark.api.requestsResponse.getChargingStationsForPosition.GetChargingStationsForPositionRequest;
import de.aipark.api.requestsResponse.getChargingStationsForPosition.GetChargingStationsForPositionResponse;
import de.aipark.api.requestsResponse.getChargingStationsForTile.GetChargingStationsForTileRequest;
import de.aipark.api.requestsResponse.getChargingStationsForTile.GetChargingStationsForTileResponse;
import de.aipark.api.requestsResponse.getCostsForParkingAreas.GetCostsForParkingAreasRequest;
import de.aipark.api.requestsResponse.getCostsForParkingAreas.GetCostsForParkingAreasResponse;
import de.aipark.api.requestsResponse.getDatasourcesToPublishForMergedId.ParkingAreaRequest;
import de.aipark.api.requestsResponse.getLiveParkEvents.GetLiveParkEventsRequest;
import de.aipark.api.requestsResponse.getLiveSpots.GetLiveSpotsForTileRequest;
import de.aipark.api.requestsResponse.getOccupancyForParkingAreas.GetOccupancyForParkingAreasRequest;
import de.aipark.api.requestsResponse.getOccupancyForParkingAreas.GetOccupancyForParkingAreasResponse;
import de.aipark.api.requestsResponse.getOptimalTrip.GetOptimalTripRequest;
import de.aipark.api.requestsResponse.getOptimalTrip.GetOptimalTripResponse;
import de.aipark.api.requestsResponse.getParkingAreasForPosition.GetParkingAreasForPositionRequest;
import de.aipark.api.requestsResponse.getParkingAreasForPosition.GetParkingAreasForPositionResponse;
import de.aipark.api.requestsResponse.getParkingAreasForPositionWithOccupancy.GetParkingAreasForPositionWithOccupancyRequest;
import de.aipark.api.requestsResponse.getParkingAreasForPositionWithOccupancy.GetParkingAreasForPositionWithOccupancyResponse;
import de.aipark.api.requestsResponse.getParkingAreasForPositionWithOccupancyForDeparture.GetParkingAreasForPositionWithOccupancyForDepartureRequest;
import de.aipark.api.requestsResponse.getParkingAreasForTile.GetParkingAreasForTileRequest;
import de.aipark.api.requestsResponse.getParkingAreasForTile.GetParkingAreasForTileResponse;
import de.aipark.api.requestsResponse.getParkingAreasForTileWithOccupancy.GetParkingAreasForTileWithOccupancyRequest;
import de.aipark.api.requestsResponse.getParkingAreasForTileWithOccupancy.GetParkingAreasForTileWithOccupancyResponse;
import de.aipark.api.requestsResponse.getParkingAreasForTileWithOccupancyForDeparture.GetParkingAreasForTileWithOccupancyForDepartureRequest;
import de.aipark.api.webservice.jsonConverter.aiparkapi.AiparkApiModule;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;
import rx.Observable;

import javax.net.ssl.SSLContext;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

/**
 * Communicate with AiPark API.
 */

public class AiparkApi implements AiparkApiEndpointInterface, Serializable {
    private AiparkApiEndpointInterface mApiEndpoint;

    public AiparkApi(String urlApi, final String apiKey) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JtsModule());
        objectMapper.registerModule(new AiparkApiModule());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

        try {
            OkHttpClient.Builder httpClient = new OkHttpClient.Builder().sslSocketFactory(createSSLContex().getSocketFactory());
            httpClient.addInterceptor(new Interceptor() {
                @Override
                public Response intercept(Chain chain) throws IOException {
                    Request original = chain.request();
                    Request request = original.newBuilder()
                            .header("User-Agent", "AIPARK")
                            .header("apikey", apiKey)
                            .method(original.method(), original.body())
                            .build();
                    return chain.proceed(request);
                }
            });
            // logging
            /*HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
            interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            httpClient.addInterceptor(interceptor);*/

            Retrofit mApiRetrofit = new Retrofit.Builder()
                    .client(httpClient.build())
                    .addCallAdapterFactory(RxJavaCallAdapterFactory.create())
                    .baseUrl(urlApi)
                    .addConverterFactory(JacksonConverterFactory.create(objectMapper))
                    .build();
            mApiEndpoint = mApiRetrofit.create(AiparkApiEndpointInterface.class);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Observable<GetParkingAreasForTileResponse> getParkingAreasForTile(GetParkingAreasForTileRequest tileParkingAreasRequest) {
        return mApiEndpoint.getParkingAreasForTile(tileParkingAreasRequest);
    }

    @Override
    public Observable<GetOccupancyForParkingAreasResponse> getOccupancyForParkingAreas(GetOccupancyForParkingAreasRequest getOccupancyForParkingAreasRequest) {
        return mApiEndpoint.getOccupancyForParkingAreas(getOccupancyForParkingAreasRequest);
    }

    @Override
    public Observable<GetParkingAreasForTileWithOccupancyResponse> getParkingAreasForTileWithOccupancy(GetParkingAreasForTileWithOccupancyRequest getParkingAreasForTileWithOccupancyRequest) {
        return mApiEndpoint.getParkingAreasForTileWithOccupancy(getParkingAreasForTileWithOccupancyRequest);
    }

    @Override
    public Observable<GetParkingAreasForTileWithOccupancyResponse> getParkingAreasForTileWithOccupancyForPosition(GetParkingAreasForTileWithOccupancyForDepartureRequest getParkingAreasForTileWithOccupancyForPositionRequest) {
        return mApiEndpoint.getParkingAreasForTileWithOccupancyForPosition(getParkingAreasForTileWithOccupancyForPositionRequest);
    }

    @Override
    public Observable<GetParkingAreasForPositionResponse> getParkingAreasForPosition(GetParkingAreasForPositionRequest getParkingAreasForPositionRequest) {
        return mApiEndpoint.getParkingAreasForPosition(getParkingAreasForPositionRequest);
    }

    @Override
    public Observable<GetParkingAreasForPositionWithOccupancyResponse> getParkingAreasForPositionWithOccupancy(GetParkingAreasForPositionWithOccupancyRequest getParkingAreasForPositionRequest) {
        return mApiEndpoint.getParkingAreasForPositionWithOccupancy(getParkingAreasForPositionRequest);
    }

    @Override
    public Observable<GetParkingAreasForPositionWithOccupancyResponse> getParkingAreasForPositionWithOccupancyForPosition(GetParkingAreasForPositionWithOccupancyForDepartureRequest getParkingAreasForPositionRequest) {
        return mApiEndpoint.getParkingAreasForPositionWithOccupancyForPosition(getParkingAreasForPositionRequest);
    }

    @Override
    public Observable<GetOptimalTripResponse> getOptimalTrip(GetOptimalTripRequest getOptimalTripRequest) {
        return mApiEndpoint.getOptimalTrip(getOptimalTripRequest);
    }

    @Override
    public Observable<List<ParkEventLiveLeaving>> getLiveParkEvents(GetLiveParkEventsRequest getLiveParkEventsRequest) {
        return mApiEndpoint.getLiveParkEvents(getLiveParkEventsRequest);
    }

    @Override
    public Observable<GetCostsForParkingAreasResponse> getCostsForParkingAreas(GetCostsForParkingAreasRequest getCostsForParkingAreasRequest) {
        return mApiEndpoint.getCostsForParkingAreas(getCostsForParkingAreasRequest);
    }

    @Override
    public Observable<GetChargingStationsForTileResponse> getChargingStationsForTile(GetChargingStationsForTileRequest getChargingStationsForTileRequest) {
        return mApiEndpoint.getChargingStationsForTile(getChargingStationsForTileRequest);
    }

    @Override
    public Observable<GetChargingStationsForPositionResponse> getChargingStationsForPosition(GetChargingStationsForPositionRequest getChargingStationsForPositionRequest) {
        return mApiEndpoint.getChargingStationsForPosition(getChargingStationsForPositionRequest);
    }

    @Override
    public Observable<List<LiveSpot>> getLiveSpotsForTile(GetLiveSpotsForTileRequest getLiveSpotsForTileRequest) {
        return mApiEndpoint.getLiveSpotsForTile(getLiveSpotsForTileRequest);
    }

    @Override
    public Observable<List<Datasource>> getDatasourcesToPublishForParkingArea(ParkingAreaRequest parkingAreaRequest) {
        return mApiEndpoint.getDatasourcesToPublishForParkingArea(parkingAreaRequest);
    }

    public static SSLContext createSSLContex() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null,null,null);
        return sslContext;
    }

}
