package de.aipark.api.tile;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import de.aipark.api.tile.Tile;

/**
 * Created by torgen on 15.06.17.
 */
public class TileMapper {

    /**
     *
     * @param tile
     * @return left upper corner of given tile
     */
    public static Point getLatLngFromTileIndex(Tile tile){
        double lat, lng;
        lat = Math.atan(Math.sinh(Math.PI- tile.getY()/Math.pow(2, tile.getZoom())*2*Math.PI))*180/Math.PI;
        lng = tile.getX()/Math.pow(2, tile.getZoom())*360-180;
        return new Point(new CoordinateArraySequence(new Coordinate[]{new Coordinate(lng,lat)}), new GeometryFactory());
    }

    /**
     *
     * @param point point
     * @param zoom zoom level
     * @return  tile of this point with given zoom level
     */
    public static Tile getTileIndexFromLatLng(Point point, int zoom){
        double xtile =  (point.getX() + 180) / 360 * (1<<zoom)  ;
        double ytile = (1 - Math.log(Math.tan(Math.toRadians(point.getY())) + 1 / Math.cos(Math.toRadians(point.getY()))) / Math.PI) / 2 * (1<<zoom) ;
        if (xtile < 0)
            xtile=0;
        if (xtile >= (1<<zoom))
            xtile=((1<<zoom)-1);
        if (ytile < 0)
            ytile=0;
        if (ytile >= (1<<zoom))
            ytile=((1<<zoom)-1);
        return new Tile(xtile,ytile, zoom);
    }
}
