package de.aipark.api.tile;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;

/**
 * Created by torgen on 15.06.17.
 */
public class Tile {
    @ApiModelProperty(value = "x value of slippy tile", dataType = "java.lang.Double", required = true, example = "17340")
    private double x;

    @ApiModelProperty(value = "y value of slippy tile", dataType = "java.lang.Double", required = true, example = "10785")
    private double y;

    @ApiModelProperty(value = "zoom level of slippy tile", dataType = "java.lang.Integer", required = true, example = "15")
    private int zoom;

    public Tile(double x, double y, int zoom) {
        this.x = x;
        this.y = y;
        this.zoom = zoom;
    }

    public Tile() {
    }

    public double getX() {
        return x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public int getZoom() {
        return zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Tile)) return false;

        Tile tile = (Tile) o;

        if (Double.compare(tile.x, x) != 0) return false;
        if (Double.compare(tile.y, y) != 0) return false;
        return zoom == tile.zoom;
    }

    @Override
    public int hashCode() {
        int result;
        long temp;
        temp = Double.doubleToLongBits(x);
        result = (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(y);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        result = 31 * result + zoom;
        return result;
    }

    @JsonIgnore
    public Tile getRoundedTile(){
        return new Tile(Math.floor(x), Math.floor(y), zoom);
    }

    @Override
    public String toString() {
        return "Tile{" +
                "x=" + x +
                ", y=" + y +
                ", zoom=" + zoom +
                '}';
    }
}

