package de.aipark.api.requestsResponse.getParkingAreasForTileWithOccupancy;

import de.aipark.api.parkingarea.ParkingAreaDataFilter;
import de.aipark.api.tile.Tile;
import io.swagger.annotations.ApiModelProperty;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by torgen on 25.09.17.
 */
public class GetParkingAreasForTileWithOccupancyRequest {
    @ApiModelProperty(value = "tile of parking areas", dataType = "de.aipark.api.tile.Tile", required = true)
    private Tile tile;

    @ApiModelProperty(value = "list of filters, filter CAR_PARK combines filters for types: \"CAR_PARK, AIRPORT,PARKING_DECK_AUTOMATED, UNDERGROUND_PARKING, UNDERGROUND_PARKING_AUTOMATED \"",
            dataType = "[Ljava.lang.String;", example = "[\"FREE\"]", required = true,
            allowableValues = ParkingAreaDataFilter.ALLOWED_VALUES_LIST)
    private List<ParkingAreaDataFilter> filters = new ArrayList<ParkingAreaDataFilter>();

    @ApiModelProperty(value = "occupancy time (UNIX time (since 1970) in milliseconds)", dataType = "java.lang.Long", required = true, example = "1476561575000")
    private Timestamp timestamp;

    public GetParkingAreasForTileWithOccupancyRequest() {
    }

    public GetParkingAreasForTileWithOccupancyRequest(Tile tile, List<ParkingAreaDataFilter> filters, Timestamp timestamp) {
        this.tile = tile;
        this.filters = filters;
        this.timestamp = timestamp;
    }

    public Tile getTile() {
        return tile;
    }

    public void setTile(Tile tile) {
        this.tile = tile;
    }

    public List<ParkingAreaDataFilter> getFilters() {
        return filters;
    }

    public void setFilters(List<ParkingAreaDataFilter> filters) {
        this.filters = filters;
    }

    public Timestamp getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String toString() {
        return "GetParkingAreasForTileWithOccupancyRequest{" +
                "tile=" + tile +
                ", filters=" + filters +
                ", timestamp=" + timestamp +
                '}';
    }
}
