package de.aipark.api.requestsResponse.getParkingAreasForPositionWithOccupancy;

import com.vividsolutions.jts.geom.Point;
import de.aipark.api.parkingarea.ParkingAreaDataFilter;
import io.swagger.annotations.ApiModelProperty;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by torgen on 27.09.17.
 */
public class GetParkingAreasForPositionWithOccupancyRequest {
    @ApiModelProperty(value = "departurePosition of parking areas", required = true)
    private Point position;

    @ApiModelProperty(value = "number of parking areas", dataType = "java.lang.Integer", required = true, example = "10")
    private Integer numberOfParkingAreas;

    @ApiModelProperty(value = "list of filters, filter CAR_PARK combines filters for types: \"CAR_PARK, AIRPORT,PARKING_DECK_AUTOMATED, UNDERGROUND_PARKING, UNDERGROUND_PARKING_AUTOMATED \"",
            dataType = "[Ljava.lang.String;", example = "[\"FREE\"]", required = true,
            allowableValues = ParkingAreaDataFilter.ALLOWED_VALUES_LIST)
    private List<ParkingAreaDataFilter> filters = new ArrayList<ParkingAreaDataFilter>();

    @ApiModelProperty(value = "occupancy time (UNIX time (since 1970) in milliseconds)", dataType = "java.lang.Long", required = true, example = "1476561575000")
    private Timestamp timestamp;

    public GetParkingAreasForPositionWithOccupancyRequest() {
    }

    public GetParkingAreasForPositionWithOccupancyRequest(Point position, Integer numberOfParkingAreas, List<ParkingAreaDataFilter> filters, Timestamp timestamp) {
        this.position = position;
        this.numberOfParkingAreas = numberOfParkingAreas;
        this.filters = filters;
        this.timestamp = timestamp;
    }

    public Point getPosition() {
        return position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public Integer getNumberOfParkingAreas() {
        return numberOfParkingAreas;
    }

    public void setNumberOfParkingAreas(Integer numberOfParkingAreas) {
        this.numberOfParkingAreas = numberOfParkingAreas;
    }

    public List<ParkingAreaDataFilter> getFilters() {
        return filters;
    }

    public void setFilters(List<ParkingAreaDataFilter> filters) {
        this.filters = filters;
    }

    public Timestamp getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String toString() {
        return "GetParkingAreasForPositionWithOccupancyRequest{" +
                "position=" + position +
                ", numberOfParkingAreas=" + numberOfParkingAreas +
                ", filters=" + filters +
                ", timestamp=" + timestamp +
                '}';
    }
}
