package de.aipark.api.requestsResponse.getLiveSpots;

import de.aipark.api.tile.Tile;
import io.swagger.annotations.ApiModelProperty;

import java.sql.Timestamp;

/**
 * Created by torgen on 02.04.18.
 */
public class GetLiveSpotsForTileRequest {
    private Tile tile;

    @ApiModelProperty(value = "start timestamp (UNIX time (since 1970) in milliseconds)", dataType = "java.lang.Long", required = true, example = "1530287188696")
    private Timestamp timestamp;

    public GetLiveSpotsForTileRequest() {
    }

    public GetLiveSpotsForTileRequest(Tile tile, Timestamp timestamp) {
        this.tile = tile;
        this.timestamp = timestamp;
    }

    public Tile getTile() {
        return tile;
    }

    public void setTile(Tile tile) {
        this.tile = tile;
    }

    public Timestamp getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String toString() {
        return "GetLiveSpotsForTileRequest{" +
                "tile=" + tile +
                ", timestamp=" + timestamp +
                '}';
    }
}
