package de.aipark.api.parkingarea;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by torgen on 13.07.17.
 */
@SuppressWarnings("unused")
public enum ParkingAreaType {
    CAR_PARK,
    UNDERGROUND_PARKING,
    AIRPORT,
    PARKINGAREA,
    ON_STREET,
    SPECIAL,
    PARK_AND_RIDE,
    PARKING_DECK_AUTOMATED,
    UNDERGROUND_PARKING_AUTOMATED,
    CUSTOMER_PARKING,
    PRIVATE,
    TRUCK,
    BUS,
    TAXI;

    public static final List<ParkingAreaType> ALL_CAR_PARK_TYPES = Arrays.asList(
            ParkingAreaType.CAR_PARK,
            ParkingAreaType.AIRPORT,
            ParkingAreaType.PARKING_DECK_AUTOMATED,
            ParkingAreaType.UNDERGROUND_PARKING,
            ParkingAreaType.UNDERGROUND_PARKING_AUTOMATED
    );

    private static Map<String, ParkingAreaType> aliasMap = new HashMap<String,ParkingAreaType>();

    static {
        aliasMap.put("TIEFGARAGE", UNDERGROUND_PARKING);
        aliasMap.put("PARKGARAGE", UNDERGROUND_PARKING);
        aliasMap.put("UNDERGROUD_PARKING", UNDERGROUND_PARKING);
        aliasMap.put("PARKHAUS", CAR_PARK);
        aliasMap.put("PARKDECK", CAR_PARK); //APCOA
        aliasMap.put("PARKEN", CAR_PARK); //z.B. Stuttgart Flughafen, siehe APCOA Parking Parser
        aliasMap.put("CITY", CAR_PARK); //z.B. City Parkhaus Experimenta Heilbronn, siehe APCOA Parking Parser
        aliasMap.put("PARKHAUS/PARKPLATZ", CAR_PARK); //z.B. Stuttgart Flughafen, siehe APCOA Parking Parser
        aliasMap.put("P+R", PARK_AND_RIDE);
        aliasMap.put("PARK & MITNEHMEN", PARKINGAREA);
        aliasMap.put("PARK & KISS", AIRPORT);
        aliasMap.put("PARK & FLY", AIRPORT);
        aliasMap.put("PARKPLATZ", PARKINGAREA);
        aliasMap.put("OFFENE FLÄCHE", PARKINGAREA);
        aliasMap.put("AUTOMATISCHE TIEFGARAGE", UNDERGROUND_PARKING_AUTOMATED);
        aliasMap.put("AUTOMATISCHES PARKHAUS", PARKING_DECK_AUTOMATED);
        aliasMap.put("STRAßENPARKPLATZ", ON_STREET);
        aliasMap.put("STRASSENPARKPLATZ", ON_STREET);
        aliasMap.put("KUNDENPARKPLATZ", CUSTOMER_PARKING);
        aliasMap.put("PRIVAT", PRIVATE);
        aliasMap.put("FLUGHAFEN", AIRPORT);
    }

    public static ParkingAreaType lookUpType(String type) {
        if (type == null) {
            return null;
        } else if (aliasMap.containsKey(type.toUpperCase())) {
            return aliasMap.get(type.toUpperCase());
        } else {
            try {
                return ParkingAreaType.valueOf(type.toUpperCase());
            } catch(IllegalArgumentException e){
                return ParkingAreaType.valueOf(type.split(",")[0].toUpperCase());
            }
        }
    }

    public static ParkingAreaType getDefaultValue() {
        return PARKINGAREA;
    }
}
