package de.aipark.api.occupancy;

import com.vividsolutions.jts.geom.Point;
import io.swagger.annotations.ApiModelProperty;

import java.sql.Timestamp;

/**
 * Created by torgen on 12.10.17.
 */
public class OccupancyForPosition {
    @ApiModelProperty(value = "departurePosition of occupancy", required = true)
    public Point position;

    /**
     * will be removed in future relase, use timestamp field instead
     */
    @Deprecated
    @ApiModelProperty(value = "will be removed in future relase, use timestamp field instead", dataType = "java.lang.Long", example = "1476561575000")
    public Timestamp time; //TODO: remove because of C++ compatibility

    @ApiModelProperty(value = "occupancy time", dataType = "java.lang.Long", required = true, example = "1476561575000")
    public Timestamp timestamp;

    @ApiModelProperty(value = "percentage probability (value between 0 and 100) for at least one open parking spot if type is P (predicted) or number of open parking spots if type is L (live number of open parking spots) or LP (predicted number of open parking spots)", required = true, example = "80")
    public float value;

    public OccupancyForPosition() {
    }

    public OccupancyForPosition(Point position, Timestamp timestamp, float value) {
        this.position = position;
        this.time = timestamp; //TODO: remove because of C++ compatibility
        this.timestamp = timestamp;
        this.value = value;
    }

    public Point getPosition() {
        return position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    /**
     * will be removed in future relase, use timestamp field instead
     */
    @Deprecated
    public Timestamp getTime() { //TODO: remove because of C++ compatibility
        return time;
    }

    /**
     * will be removed in future relase, use timestamp field instead
     */
    @Deprecated
    public void setTime(Timestamp time) { //TODO: remove because of C++ compatibility
        this.time = time;
    }

    public Timestamp getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public float getValue() {
        return value;
    }

    public void setValue(float value) {
        this.value = value;
    }
}
