package de.aipark.api.datasource;

import io.swagger.annotations.ApiModelProperty;

@SuppressWarnings("unused")
public class Datasource {

    @ApiModelProperty(value = "datasource name", example = "CITY_BARCELONA")
    private String type;

    @ApiModelProperty(value = "priority", example = "200")
    private Integer priority,
            priorityName,
            priorityShape,
            priorityCapacity,
            priorityType,
            priorityCapacityWoman,
            priorityCapacityDisabled,
            priorityPrice,
            priorityClosed,
            priorityDisc,
            priorityResidential,
            priorityEntrance,
            priorityCharging,
            priorityOrientation;

    @ApiModelProperty(value = "license informations")
    private DatasourceLicense license = null;

    @ApiModelProperty(value = "used for displaying datasource when it needs to be published due to license conditions", example = "Default Datasource")
    private String label = null;

    public Datasource(){

    }

    public Datasource(String type, Integer priority) {
        this.type = type;
        this.priority = priority;
        this.priorityName = priority;
        this.priorityShape = priority;
        this.priorityCapacity = priority;
        this.priorityType = priority;
        this.priorityCapacityWoman = priority;
        this.priorityCapacityDisabled = priority;
        this.priorityPrice = priority;
        this.priorityClosed = priority;
        this.priorityDisc = priority;
        this.priorityResidential = priority;
        this.priorityEntrance = priority;
        this.priorityCharging = priority;
        this.priorityOrientation = priority;
    }

    public Datasource(String type) {
        this.type = type;
        this.priority = 0;
        this.priorityName = 0;
        this.priorityShape = 0;
        this.priorityCapacity = 0;
        this.priorityType = 0;
        this.priorityCapacityWoman = 0;
        this.priorityCapacityDisabled = 0;
        this.priorityPrice = 0;
        this.priorityClosed = 0;
        this.priorityDisc = 0;
        this.priorityResidential = 0;
        this.priorityEntrance = 0;
        this.priorityCharging = 0;
        this.priorityOrientation = 0;
    }

    /**
     * use other constructor, this will be removed in future release
     */
    @Deprecated
    public Datasource(String type, Integer priority, Integer priorityName, Integer priorityShape, Integer priorityCapacity,
                      Integer priorityType, Integer priorityCapacityWoman, Integer priorityCapacityDisabled, Integer priorityPrice,
                      Integer priorityClosed, Integer priorityDisc, Integer priorityResidential, Integer priorityEntrance,
                      Integer priorityCharging) {
        this.type = type;
        this.priority = priority;
        this.priorityName = priorityName;
        this.priorityShape = priorityShape;
        this.priorityCapacity = priorityCapacity;
        this.priorityType = priorityType;
        this.priorityCapacityWoman = priorityCapacityWoman;
        this.priorityCapacityDisabled = priorityCapacityDisabled;
        this.priorityPrice = priorityPrice;
        this.priorityClosed = priorityClosed;
        this.priorityDisc = priorityDisc;
        this.priorityResidential = priorityResidential;
        this.priorityEntrance = priorityEntrance;
        this.priorityCharging = priorityCharging;
        this.priorityOrientation = priorityName;
    }

    public Datasource(String type, Integer priority, Integer priorityName, Integer priorityShape, Integer priorityCapacity,
                      Integer priorityType, Integer priorityCapacityWoman, Integer priorityCapacityDisabled, Integer priorityPrice,
                      Integer priorityClosed, Integer priorityDisc, Integer priorityResidential, Integer priorityEntrance,
                      Integer priorityCharging, Integer priorityOrientation) {
        this.type = type;
        this.priority = priority;
        this.priorityName = priorityName;
        this.priorityShape = priorityShape;
        this.priorityCapacity = priorityCapacity;
        this.priorityType = priorityType;
        this.priorityCapacityWoman = priorityCapacityWoman;
        this.priorityCapacityDisabled = priorityCapacityDisabled;
        this.priorityPrice = priorityPrice;
        this.priorityClosed = priorityClosed;
        this.priorityDisc = priorityDisc;
        this.priorityResidential = priorityResidential;
        this.priorityEntrance = priorityEntrance;
        this.priorityCharging = priorityCharging;
        this.priorityOrientation = priorityOrientation;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriorityName() {
        return priorityName;
    }

    public void setPriorityName(Integer priorityName) {
        this.priorityName = priorityName;
    }

    public Integer getPriorityShape() {
        return priorityShape;
    }

    public void setPriorityShape(Integer priorityShape) {
        this.priorityShape = priorityShape;
    }

    public Integer getPriorityCapacity() {
        return priorityCapacity;
    }

    public void setPriorityCapacity(Integer priorityCapacity) {
        this.priorityCapacity = priorityCapacity;
    }

    public Integer getPriorityType() {
        return priorityType;
    }

    public void setPriorityType(Integer priorityType) {
        this.priorityType = priorityType;
    }

    public Integer getPriorityCapacityWoman() {
        return priorityCapacityWoman;
    }

    public void setPriorityCapacityWoman(Integer priorityCapacityWoman) {
        this.priorityCapacityWoman = priorityCapacityWoman;
    }

    public Integer getPriorityCapacityDisabled() {
        return priorityCapacityDisabled;
    }

    public void setPriorityCapacityDisabled(Integer priorityCapacityDisabled) {
        this.priorityCapacityDisabled = priorityCapacityDisabled;
    }

    public Integer getPriorityPrice() {
        return priorityPrice;
    }

    public void setPriorityPrice(Integer priorityPrice) {
        this.priorityPrice = priorityPrice;
    }

    public Integer getPriorityClosed() {
        return priorityClosed;
    }

    public void setPriorityClosed(Integer priorityClosed) {
        this.priorityClosed = priorityClosed;
    }

    public Integer getPriorityDisc() {
        return priorityDisc;
    }

    public void setPriorityDisc(Integer priorityDisc) {
        this.priorityDisc = priorityDisc;
    }

    public Integer getPriorityResidential() {
        return priorityResidential;
    }

    public void setPriorityResidential(Integer priorityResidential) {
        this.priorityResidential = priorityResidential;
    }

    public Integer getPriorityEntrance() {
        return priorityEntrance;
    }

    public void setPriorityEntrance(Integer priorityEntrance) {
        this.priorityEntrance = priorityEntrance;
    }

    public Integer getPriorityCharging() {
        return priorityCharging;
    }

    public void setPriorityCharging(Integer priorityCharging) {
        this.priorityCharging = priorityCharging;
    }

    public Integer getPriorityOrientation() {
        return priorityOrientation;
    }

    public void setPriorityOrientation(Integer priorityOrientation) {
        this.priorityOrientation = priorityOrientation;
    }

    public DatasourceLicense getLicense() {
        return license;
    }

    public void setLicense(DatasourceLicense license) {
        this.license = license;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Datasource)) return false;

        Datasource that = (Datasource) o;

        if (type != null ? !type.equals(that.type) : that.type != null) return false;
        if (priority != null ? !priority.equals(that.priority) : that.priority != null) return false;
        if (priorityName != null ? !priorityName.equals(that.priorityName) : that.priorityName != null) return false;
        if (priorityShape != null ? !priorityShape.equals(that.priorityShape) : that.priorityShape != null)
            return false;
        if (priorityCapacity != null ? !priorityCapacity.equals(that.priorityCapacity) : that.priorityCapacity != null)
            return false;
        if (priorityType != null ? !priorityType.equals(that.priorityType) : that.priorityType != null) return false;
        if (priorityCapacityWoman != null ? !priorityCapacityWoman.equals(that.priorityCapacityWoman) : that.priorityCapacityWoman != null)
            return false;
        if (priorityCapacityDisabled != null ? !priorityCapacityDisabled.equals(that.priorityCapacityDisabled) : that.priorityCapacityDisabled != null)
            return false;
        if (priorityPrice != null ? !priorityPrice.equals(that.priorityPrice) : that.priorityPrice != null)
            return false;
        if (priorityClosed != null ? !priorityClosed.equals(that.priorityClosed) : that.priorityClosed != null)
            return false;
        if (priorityDisc != null ? !priorityDisc.equals(that.priorityDisc) : that.priorityDisc != null) return false;
        if (priorityResidential != null ? !priorityResidential.equals(that.priorityResidential) : that.priorityResidential != null)
            return false;
        if (priorityEntrance != null ? !priorityEntrance.equals(that.priorityEntrance) : that.priorityEntrance != null)
            return false;
        if (priorityCharging != null ? !priorityCharging.equals(that.priorityCharging) : that.priorityCharging != null)
            return false;
        if (priorityOrientation != null ? !priorityOrientation.equals(that.priorityOrientation) : that.priorityOrientation != null)
            return false;
        if (license != null ? !license.equals(that.license) : that.license != null) return false;
        return label != null ? label.equals(that.label) : that.label == null;
    }

    @Override
    public int hashCode() {
        int result = type != null ? type.hashCode() : 0;
        result = 31 * result + (priority != null ? priority.hashCode() : 0);
        result = 31 * result + (priorityName != null ? priorityName.hashCode() : 0);
        result = 31 * result + (priorityShape != null ? priorityShape.hashCode() : 0);
        result = 31 * result + (priorityCapacity != null ? priorityCapacity.hashCode() : 0);
        result = 31 * result + (priorityType != null ? priorityType.hashCode() : 0);
        result = 31 * result + (priorityCapacityWoman != null ? priorityCapacityWoman.hashCode() : 0);
        result = 31 * result + (priorityCapacityDisabled != null ? priorityCapacityDisabled.hashCode() : 0);
        result = 31 * result + (priorityPrice != null ? priorityPrice.hashCode() : 0);
        result = 31 * result + (priorityClosed != null ? priorityClosed.hashCode() : 0);
        result = 31 * result + (priorityDisc != null ? priorityDisc.hashCode() : 0);
        result = 31 * result + (priorityResidential != null ? priorityResidential.hashCode() : 0);
        result = 31 * result + (priorityEntrance != null ? priorityEntrance.hashCode() : 0);
        result = 31 * result + (priorityCharging != null ? priorityCharging.hashCode() : 0);
        result = 31 * result + (priorityOrientation != null ? priorityOrientation.hashCode() : 0);
        result = 31 * result + (license != null ? license.hashCode() : 0);
        result = 31 * result + (label != null ? label.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Datasource{" +
                "type='" + type + '\'' +
                ", priority=" + priority +
                ", license=" + license +
                ", label='" + label + '\'' +
                '}';
    }
}
