package de.aipark.api.chargingstation;

import de.aipark.api.payment.PriceModel;
import de.aipark.api.parkingarea.Schedule;

import java.util.Currency;
import java.util.ResourceBundle;

/**
 * Created by torgen on 06.02.18.
 */
public class ChargingPriceEntry extends PriceModel{
    private ChargingPriceModel model;
    private Schedule schedule;
    private Integer initialPrice;
    private Integer priceKW;

    public ChargingPriceEntry() {
    }

    public ChargingPriceEntry(Integer fromMinute, Integer untilMinute, Integer interval, Integer priceInCent, Integer priority, String description, Integer maxPriceInCent, Currency currency, ChargingPriceModel model, Schedule schedule, int initialPrice, int priceKW) {
        super(fromMinute, untilMinute, interval, priceInCent, priority, description, maxPriceInCent, currency);
        this.model = model;
        this.schedule = schedule;
        this.initialPrice = initialPrice;
        this.priceKW = priceKW;
    }

    public ChargingPriceModel getModel() {
        return model;
    }

    public void setModel(ChargingPriceModel model) {
        this.model = model;
    }

    public Schedule getSchedule() {
        return schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public int getInitialPrice() {
        return initialPrice;
    }

    public void setInitialPrice(int initialPrice) {
        this.initialPrice = initialPrice;
    }

    public int getPriceKW() {
        return priceKW;
    }

    public void setPriceKW(int priceKW) {
        this.priceKW = priceKW;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ChargingPriceEntry)) return false;
        if (!super.equals(o)) return false;

        ChargingPriceEntry that = (ChargingPriceEntry) o;

        if (getInitialPrice() != that.getInitialPrice()) return false;
        if (getPriceKW() != that.getPriceKW()) return false;
        if (getModel() != null ? !getModel().equals(that.getModel()) : that.getModel() != null) return false;
        return getSchedule() != null ? getSchedule().equals(that.getSchedule()) : that.getSchedule() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (getModel() != null ? getModel().hashCode() : 0);
        result = 31 * result + (getSchedule() != null ? getSchedule().hashCode() : 0);
        result = 31 * result + getInitialPrice();
        result = 31 * result + getPriceKW();
        return result;
    }

    @Override
    public String toString() {
        ResourceBundle bundle = ResourceBundle.getBundle( "Api" );
        String result = "";
        if(schedule != null){
            result += schedule.toString();
        }
        if(model != null){
            if(!result.isEmpty()){
                result += " ";
            }
            result += model.getName();
        }
        String priceString = "";
        if(initialPrice != null){
            priceString += bundle.getString("initialPrice") + " " + getCurrencyAsString(initialPrice).trim();
        }
        if(priceKW != null){
            if(!priceString.isEmpty()){
                priceString += ", ";
            }
            priceString += getCurrencyAsString(initialPrice).trim() + bundle.getString("priceKW");
        }
        if(!super.toString().isEmpty()){
            if(!priceString.isEmpty()){
                priceString += ", ";
            }
            priceString += super.toString();
        }
        if(!priceString.isEmpty()){
            if(!result.isEmpty()){
                result += "\n\t";
            }
            result += priceString;
        }

        return result;
    }
}
