/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.chargingstation;

import io.swagger.annotations.ApiModelProperty;

public class ChargingPlugType {
    @ApiModelProperty(value="type of charging plug", dataType="java.lang.String", required=true, example="TYP2")
    private String description;
    @ApiModelProperty(value="voltage", dataType="java.lang.Integer", required=true, example="220")
    private Integer voltage;
    @ApiModelProperty(value="maximal ampere", dataType="java.lang.Integer", required=true, example="10")
    private Integer maxampere;
    @ApiModelProperty(value="maximal watt", dataType="java.lang.Integer", required=true, example="3000")
    private Integer maxwatt;

    public ChargingPlugType(Types description, Integer voltage, Integer maxampere, Integer maxwatt) {
        this.description = description.toString();
        this.voltage = voltage;
        this.maxampere = maxampere;
        this.maxwatt = maxwatt;
    }

    public ChargingPlugType(String description, Integer voltage, Integer maxampere, Integer maxwatt) {
        this.description = description;
        this.voltage = voltage;
        this.maxampere = maxampere;
        this.maxwatt = maxwatt;
    }

    public ChargingPlugType() {
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(Types description) {
        this.description = description.toString();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getVoltage() {
        return this.voltage;
    }

    public void setVoltage(Integer voltage) {
        this.voltage = voltage;
    }

    public Integer getMaxampere() {
        return this.maxampere;
    }

    public void setMaxampere(Integer maxampere) {
        this.maxampere = maxampere;
    }

    public Integer getMaxwatt() {
        return this.maxwatt;
    }

    public void setMaxwatt(Integer maxwatt) {
        this.maxwatt = maxwatt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChargingPlugType plugType = (ChargingPlugType)o;
        if (this.description != plugType.description) {
            return false;
        }
        if (this.voltage != null ? !this.voltage.equals(plugType.voltage) : plugType.voltage != null) {
            return false;
        }
        if (this.maxampere != null ? !this.maxampere.equals(plugType.maxampere) : plugType.maxampere != null) {
            return false;
        }
        return this.maxwatt != null ? this.maxwatt.equals(plugType.maxwatt) : plugType.maxwatt == null;
    }

    public int hashCode() {
        int result = this.description != null ? this.description.hashCode() : 0;
        result = 31 * result + (this.voltage != null ? this.voltage.hashCode() : 0);
        result = 31 * result + (this.maxampere != null ? this.maxampere.hashCode() : 0);
        result = 31 * result + (this.maxwatt != null ? this.maxwatt.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ChargingPlugType{description=" + this.description + ", voltage=" + this.voltage + ", maxampere=" + this.maxampere + ", maxwatt=" + this.maxwatt + '}';
    }

    public static enum Types {
        ENERGY_BUS,
        CEE_400V_63A,
        CEE_400V_32A,
        CEE_PLUS_400V,
        CEE_PLUS_230V,
        CEE_400V_16A,
        CEE_230V_16A,
        CEI_23,
        CH_T25,
        CH_T15,
        CH_T23,
        CH_T13,
        UK_TYP_G,
        SCHUKO,
        CEE,
        TYP1,
        TYP1_COMBO,
        TYP1_CABLE,
        TYP2,
        TYP2_COMBO,
        TYP2_CABLE_GEN_1,
        TYP2_CABLE,
        TYP3,
        TYP3A,
        TYP3C,
        TYP_E,
        CHADEMO,
        TESLA,
        TESLA_HPC,
        TESLA_STANDARD,
        TESLA_SUPERCHARGER,
        TESLA_ROADSTER,
        BS1363,
        AS3112,
        SEV,
        UNKNOWN,
        MAGNE,
        NEMA;

    }
}

