/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.requestsResponse.getOptimalTrip;

import de.aipark.api.optimalTrip.OptimalTrip;
import de.aipark.api.optimalTrip.Situation;
import de.aipark.api.parkingarea.MapEntry;
import io.swagger.annotations.ApiModelProperty;
import java.util.ResourceBundle;

public class GetOptimalTripResponse {
    @ApiModelProperty(value="optimal trips with priority, higher value means higher priority")
    private MapEntry<Integer, OptimalTrip> optimalTrips;
    private Situation situation;

    public GetOptimalTripResponse() {
        this.optimalTrips = new MapEntry();
    }

    public GetOptimalTripResponse(MapEntry<Integer, OptimalTrip> optimalTrips, Situation situation) {
        this.optimalTrips = optimalTrips;
        this.situation = situation;
    }

    public MapEntry<Integer, OptimalTrip> getOptimalTrips() {
        return this.optimalTrips;
    }

    public void setOptimalTrips(MapEntry<Integer, OptimalTrip> optimalTrips) {
        this.optimalTrips = optimalTrips;
    }

    public Situation getSituation() {
        return this.situation;
    }

    public void setSituation(Situation situation) {
        this.situation = situation;
    }

    public String toString() {
        ResourceBundle bundle = ResourceBundle.getBundle("Api");
        String result = "";
        switch (this.situation) {
            case GOOD: {
                result = result + bundle.getString("goodSituation");
                break;
            }
            case MIDDLE: {
                result = result + bundle.getString("middleSituation");
                break;
            }
            case BAD: {
                result = result + bundle.getString("badSituation");
                break;
            }
            case UNKNOWN: {
                result = result + bundle.getString("unknownSituation");
            }
        }
        if (this.optimalTrips.getEntryList().size() < 1) {
            result = result + ", " + bundle.getString("noAreasNearToDestination");
        } else if (!this.situation.equals((Object)Situation.UNKNOWN)) {
            result = result + ", " + this.optimalTrips.getEntryList().get(0).getValue().toString();
        }
        result = result + ".";
        return result;
    }
}

